/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Iterator;
import java.util.Vector;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.swing.TimerThread;

public class Timer {
    protected Vector actionListeners = new Vector();
    protected int delay = 100;
    protected int initialDelay = 100;
    protected boolean running = false;
    protected boolean coalesce = true;
    protected boolean repeats = true;
    protected TimerThread timerThread = null;

    public Timer(int delay, ActionListener l) {
        this.delay = delay;
        this.initialDelay = delay;
        this.addActionListener(l);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    protected synchronized void fireActionPerformed(ActionEvent e) {
        Iterator i = this.actionListeners.iterator();
        while (i.hasNext()) {
            ((ActionListener)i.next()).actionPerformed(e);
        }
    }

    public synchronized int getDelay() {
        return this.delay;
    }

    public synchronized int getInitialDelay() {
        return this.initialDelay;
    }

    public synchronized boolean isCoalesce() {
        return this.coalesce;
    }

    public synchronized boolean isRepeats() {
        return this.repeats;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void restart() {
        this.delay = this.initialDelay;
        this.stop();
        this.start();
    }

    public synchronized void setCoalesce(boolean b) {
        this.coalesce = b;
    }

    public synchronized void setDelay(int delay) {
        this.delay = delay;
    }

    public synchronized void setInitialDelay(int delay) {
        this.initialDelay = delay;
    }

    public synchronized void setRepeats(boolean b) {
        this.repeats = b;
    }

    protected synchronized void setRunning(boolean b) {
        this.running = b;
    }

    public synchronized void start() {
        if (!this.isRunning()) {
            this.setRunning(true);
            this.timerThread = new TimerThread(this);
            this.timerThread.start();
        }
    }

    public synchronized void stop() {
        this.setRunning(false);
        this.timerThread = null;
    }
}

