/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Calendar;
import java.util.Date;
import swingwtx.swing.AbstractSpinnerModel;

public class SpinnerDateModel
extends AbstractSpinnerModel {
    private Comparable start;
    private Comparable end;
    private Calendar value;
    private int calendarField;

    public SpinnerDateModel() {
        this(new Date(), null, null, 5);
    }

    public SpinnerDateModel(Date value, Comparable start, Comparable end, int calendarField) {
        this.start = start;
        this.end = end;
        this.calendarField = calendarField;
        this.value = Calendar.getInstance();
        this.value.setTime(value);
    }

    public void setStart(Comparable start) {
        this.start = start;
        this.fireStateChanged();
    }

    public Comparable getStart() {
        return this.start;
    }

    public void setEnd(Comparable end) {
        this.end = end;
        this.fireStateChanged();
    }

    public Comparable getEnd() {
        return this.end;
    }

    public void setCalendarField(int calendarField) {
        this.calendarField = calendarField;
        this.fireStateChanged();
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    public Object getNextValue() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.value.getTime());
        cal.add(this.calendarField, 1);
        Date next = cal.getTime();
        return this.end == null || this.end.compareTo(next) >= 0 ? next : null;
    }

    public Object getPreviousValue() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.value.getTime());
        cal.add(this.calendarField, -1);
        Date prev = cal.getTime();
        return this.start == null || this.start.compareTo(prev) <= 0 ? prev : null;
    }

    public Date getDate() {
        return this.value.getTime();
    }

    public Object getValue() {
        return this.value.getTime();
    }

    public void setValue(Object value) {
        this.value.setTime((Date)value);
        this.fireStateChanged();
    }
}

