/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;

public final class Region {
    public int handle;
    Device device;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = OS.NewRgn();
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    Region(Device device, int handle) {
        this.device = device;
        this.handle = handle;
    }

    public void add(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (pointArray.length < 2) {
            return;
        }
        int polyRgn = OS.NewRgn();
        OS.OpenRgn();
        OS.MoveTo((short)((short)pointArray[0]), (short)((short)pointArray[1]));
        int i = 1;
        while (i < pointArray.length / 2) {
            OS.LineTo((short)((short)pointArray[2 * i]), (short)((short)pointArray[2 * i + 1]));
            ++i;
        }
        OS.LineTo((short)((short)pointArray[0]), (short)((short)pointArray[1]));
        OS.CloseRgn((int)polyRgn);
        OS.UnionRgn((int)this.handle, (int)polyRgn, (int)this.handle);
        OS.DisposeRgn((int)polyRgn);
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        if (rect.width < 0 || rect.height < 0) {
            SWT.error(5);
        }
        int rectRgn = OS.NewRgn();
        Rect r = new Rect();
        OS.SetRect((Rect)r, (short)((short)rect.x), (short)((short)rect.y), (short)((short)(rect.x + rect.width)), (short)((short)(rect.y + rect.height)));
        OS.RectRgn((int)rectRgn, (Rect)r);
        OS.UnionRgn((int)this.handle, (int)rectRgn, (int)this.handle);
        OS.DisposeRgn((int)rectRgn);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.UnionRgn((int)this.handle, (int)region.handle, (int)this.handle);
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        org.eclipse.swt.internal.carbon.Point point = new org.eclipse.swt.internal.carbon.Point();
        OS.SetPt((org.eclipse.swt.internal.carbon.Point)point, (short)((short)x), (short)((short)y));
        return OS.PtInRgn((org.eclipse.swt.internal.carbon.Point)point, (int)this.handle);
    }

    public boolean contains(Point pt) {
        if (pt == null) {
            SWT.error(4);
        }
        return this.contains(pt.x, pt.y);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        OS.DisposeRgn((int)this.handle);
        this.handle = 0;
        this.device = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Rect bounds = new Rect();
        OS.GetRegionBounds((int)this.handle, (Rect)bounds);
        int width = bounds.right - bounds.left;
        int height = bounds.bottom - bounds.top;
        return new Rectangle(bounds.left, bounds.top, width, height);
    }

    public static Region carbon_new(Device device, int handle) {
        return new Region(device, handle);
    }

    public int hashCode() {
        return this.handle;
    }

    public void intersect(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        if (rect.width < 0 || rect.height < 0) {
            SWT.error(5);
        }
        int rectRgn = OS.NewRgn();
        Rect r = new Rect();
        OS.SetRect((Rect)r, (short)((short)rect.x), (short)((short)rect.y), (short)((short)(rect.x + rect.width)), (short)((short)(rect.y + rect.height)));
        OS.RectRgn((int)rectRgn, (Rect)r);
        OS.SectRgn((int)this.handle, (int)rectRgn, (int)this.handle);
        OS.DisposeRgn((int)rectRgn);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.SectRgn((int)this.handle, (int)region.handle, (int)this.handle);
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Rect rect = new Rect();
        OS.SetRect((Rect)rect, (short)((short)x), (short)((short)y), (short)((short)(x + width)), (short)((short)(y + height)));
        return OS.RectInRgn((Rect)rect, (int)this.handle);
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.EmptyRgn((int)this.handle);
    }

    public void subtract(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (pointArray.length < 2) {
            return;
        }
        int polyRgn = OS.NewRgn();
        OS.OpenRgn();
        OS.MoveTo((short)((short)pointArray[0]), (short)((short)pointArray[1]));
        int i = 1;
        while (i < pointArray.length / 2) {
            OS.LineTo((short)((short)pointArray[2 * i]), (short)((short)pointArray[2 * i + 1]));
            ++i;
        }
        OS.LineTo((short)((short)pointArray[0]), (short)((short)pointArray[1]));
        OS.CloseRgn((int)polyRgn);
        OS.DiffRgn((int)this.handle, (int)polyRgn, (int)this.handle);
        OS.DisposeRgn((int)polyRgn);
    }

    public void subtract(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        if (rect.width < 0 || rect.height < 0) {
            SWT.error(5);
        }
        int rectRgn = OS.NewRgn();
        Rect r = new Rect();
        OS.SetRect((Rect)r, (short)((short)rect.x), (short)((short)rect.y), (short)((short)(rect.x + rect.width)), (short)((short)(rect.y + rect.height)));
        OS.RectRgn((int)rectRgn, (Rect)r);
        OS.DiffRgn((int)this.handle, (int)rectRgn, (int)this.handle);
        OS.DisposeRgn((int)rectRgn);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.DiffRgn((int)this.handle, (int)region.handle, (int)this.handle);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

