/***************************************************************************
                          player.h  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLAYER_H
#define PLAYER_H

#include "player_data.h"
#include "player_interface.h"
#include "mutex_lock.h"


/**
  *@author Juan Sebastian Linietsky
  */

class Player {

	Song *song;
	MidiOutDeviceManager *midiout;

	Player_Data data;
	Player_Interface parser;
	Event_Queue queue;
	Event_Execute runner;
	Mutex_Lock *lock;

	int old_mode;
	void process_row();
	void reset_internal();
	void stop_internal();

        bool finished;
public:

	enum Play_Mode {
                PLAY_NOTHING,
		PLAY_PATTERN,
		PLAY_SONG
	};

	void send_direct_note_on(int p_track,char p_note, char p_volume);
	void send_direct_note_off(int p_track,char p_note, char p_volume);

       	void play_note_realtime(int p_track,int p_pattern,int p_column,int p_row);
	void play_row_realtime(int p_pattern,int p_row);
        void play(int p_mode=PLAY_SONG,int p_start=0,int p_row_start=0,int p_order_start=-1);
	
	int get_playing_row();
	int get_playing_pattern();
	int get_playing_order();
	int get_playing_rpq();
	int get_playing_tempo();

	void stop();
	void reset();

	void mute_track(int track);
	void unmute_track(int track);
	void solo_track(int track);

	void update_timer(int p_msecs_elapsed);

	void set_song(Song *p_song);
	void set_midiout(MidiOutDeviceManager *p_midiout);
	void set_lock(Mutex_Lock *p_lock);

	bool finished_playing();
	
	Play_Mode get_play_mode();
	
	Player();
	~Player();

};

#endif
