/***************************************************************************
                          midiout_midifile_device.cpp  -  description
                             -------------------
    begin                : Tue Jan 1 2002
    copyright            : (C) 2002 by red
    email                : red@server
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "midiout_midifile_device.h"

void MidiOut_MidiFile_Device::open_file(string p_filename) {


 	writer.open(p_filename.c_str());
 	write_begining();
 	chunk_length=1;
 	current_time=old_time=0;
}

void MidiOut_MidiFile_Device::close_file() {

	unsigned char aux_byte;
	unsigned inverted=0;
	int i;


	writer.store_byte(0x00);
	writer.store_byte(0xFF);
	writer.store_byte(0x2F);
	writer.store_byte(0x00);
	chunk_length+=4;
	
	writer.seek(18);
	
	for (i=0;i<4;i++) { //invert it
	
		if (i!=0) {
			inverted<<=8;
			chunk_length>>=8;
		}
		
		inverted|=chunk_length&0xFF;
	}
	
	chunk_length=inverted;

	
	for (i=0;i<4;i++) { //invert it	
		
		aux_byte=chunk_length&0xFF;
		writer.store_byte(aux_byte);
		chunk_length>>=8;	
	}
	
	
	writer.close();
}

void MidiOut_MidiFile_Device::set_current_time_offset(int p_time) {

	current_time=p_time;
}

void MidiOut_MidiFile_Device::write_vlength_number(unsigned p_number) {

	Uint32 buffer;
	buffer = p_number & 0x7F;

	while ( (p_number >>= 7) ) {
	
		buffer <<= 8;
		buffer |= ((p_number & 0x7F) | 0x80);
	}

	while (1) {

		unsigned char aux_byte;
		
		aux_byte=buffer&0xFF;
		writer.store_byte(aux_byte);
		chunk_length++;	

		if (aux_byte & 0x80) {
		
			buffer >>= 8;
			

		} else
			break;
	}


	
/*	
	while (p_number>127) {
	
		unsigned char aux_num;
		aux_num=p_number&127;
		p_number>>=7;
		aux_num|=128;
		writer.store_byte(aux_num);
		chunk_length++;
	}
	
	writer.store_byte(p_number);	
	
	chunk_length++;	
*/
}

void MidiOut_MidiFile_Device::write_begining() {

	//header

	writer.store_byte('M');
	writer.store_byte('T');
	writer.store_byte('h');
	writer.store_byte('d'); //header
//4	
	writer.store_byte(0);
	writer.store_byte(0);
	writer.store_byte(0);
	writer.store_byte(6); // header length
//8	
	writer.store_byte(0);
	writer.store_byte(0); // format 0
//10
	writer.store_byte(0);
	writer.store_byte(1); // 1 track
//12
//	writer.store_byte(0xE7);
//	writer.store_byte(0x28); // Each increment of delta-time represents a millisecond
	writer.store_byte(1);
	writer.store_byte(0xF4);
//14
	
	//Track
	
	writer.store_byte('M');
	writer.store_byte('T');
	writer.store_byte('r');
	writer.store_byte('k'); //header

//18	
	writer.store_byte(0);
	writer.store_byte(0);
	writer.store_byte(0);
	writer.store_byte(0); // length = 0 for now
//22		
}

void MidiOut_MidiFile_Device::write_delta_time() {

	write_vlength_number(current_time-old_time);
	old_time=current_time;

}


bool MidiOut_MidiFile_Device::enable_subdevice(int subdevicenum) {

	return true;
}
bool MidiOut_MidiFile_Device::disable_subdevice(int subdevicenum) {

	return true;
}

string MidiOut_MidiFile_Device::get_subdevice_name(int subdevicenum) {

	return "Midi Disk Writer";
}

//midi
void MidiOut_MidiFile_Device::send_MIDI_noteon(int subdevice,char channel, char note, char velocity) {

	write_delta_time();
	writer.store_byte(0x90 | channel);
	writer.store_byte(note);
  	writer.store_byte(velocity);
  	chunk_length+=3;

}
void MidiOut_MidiFile_Device::send_MIDI_noteoff(int subdevice,char channel, char note, char velocity) {

	write_delta_time();
	writer.store_byte(0x80 | channel);
	writer.store_byte(note);
	writer.store_byte(velocity);
  	chunk_length+=3;
}
void MidiOut_MidiFile_Device::send_MIDI_program(int subdevice,char channel, char patch) {

	write_delta_time();
	writer.store_byte(0xC0 | channel);
	writer.store_byte(patch);
  	chunk_length+=2;

}
void MidiOut_MidiFile_Device::send_MIDI_control(int subdevice,char channel, char controller, char value) {

	write_delta_time();
	
	writer.store_byte(0xB0 | channel);
	writer.store_byte(controller);
	writer.store_byte(value);
  	chunk_length+=3;

}
void MidiOut_MidiFile_Device::send_MIDI_pitch_bender(int subdevice,char channel, int value) {

	write_delta_time();

	writer.store_byte(0xE0 | channel);
	writer.store_byte(value&63);
	writer.store_byte(value >> 7);
  	chunk_length+=3;
}
void MidiOut_MidiFile_Device::send_MIDI_note_aftertouch(int subdevice,char channel, char note, char pressure) {

	write_delta_time();
	writer.store_byte(0xA0 | channel);
	writer.store_byte(pressure);
  	chunk_length+=2;	
}


void MidiOut_MidiFile_Device::send_MIDI_channel_aftertouch(int subdevice,char channel, char pressure) {

	write_delta_time();
	writer.store_byte(0xD0 | channel);
	writer.store_byte(pressure);
  	chunk_length+=2;	
}
void MidiOut_MidiFile_Device::send_MIDI_RPN(int subdevice, char channel, char lsb, char msb, char datamsb, char datalsb) {

        send_MIDI_control(subdevice,channel,0x65,msb);
        send_MIDI_control(subdevice,channel,0x64,lsb);
        send_MIDI_control(subdevice,channel,0x06,datamsb);
        send_MIDI_control(subdevice,channel,0x26,datalsb);
}
void MidiOut_MidiFile_Device::send_MIDI_reset(int subdevice) {


}

void MidiOut_MidiFile_Device::device_wait(int wait_amount) {


}

void MidiOut_MidiFile_Device::play_notify() {


}
void MidiOut_MidiFile_Device::stop_notify() {


}


MidiOut_MidiFile_Device::MidiOut_MidiFile_Device() {
}

MidiOut_MidiFile_Device::~MidiOut_MidiFile_Device(){

}
