/***************************************************************************
                          loader_it.cpp  -  description
                             -------------------
    begin                : Tue Feb 20 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "loader_it.h"


const char * Loader_IT::IT_Version[]={
		
	"ImpulseTracker  .  ",
	"Compressed ImpulseTracker  .  ",
	"ImpulseTracker 2.14p3",
	"Compressed ImpulseTracker 2.14p3",
	"ImpulseTracker 2.14p4",
	"Compressed ImpulseTracker 2.14p4",
};



Loader_IT::Loader_IT(){


	// char arrays to cstrings
	header.identifier[4]=0;
	header.songname[26]=0;

}

Loader_IT::~Loader_IT(){
}


/*************************************************************
   L O A D    H E A D E R
**************************************************************/

int Loader_IT::load_header() {
	
	string aux_string;

	file_read.get_byte_array((Uint8*)header.identifier,4);
	file_read.get_byte_array((Uint8*)header.songname,26);
	file_read.get_byte_array((Uint8*)header.blank01,2);
	file_read.get_word(header.ordnum);
	file_read.get_word(header.insnum);
	file_read.get_word(header.smpnum);
	file_read.get_word(header.patnum);
	file_read.get_word(header.cwt);		/* Created with tracker (y.xx = 0x0yxx) */
	file_read.get_word(header.cmwt);		/* Compatible with tracker ver > than val. */
	file_read.get_word(header.flags);
	file_read.get_word(header.special);
	file_read.get_byte(header.globvol);
	file_read.get_byte(header.mixvol);		/* mixing volume [ignored] */
	file_read.get_byte(header.initspeed);
	file_read.get_byte(header.inittempo);
	file_read.get_byte(header.pansep);		/* panning separation between channels */
	file_read.get_byte(header.zerobyte);
	file_read.get_word(header.msglength);
	file_read.get_dword(header.msgoffset);
	file_read.get_byte_array((Uint8*)header.blank02,4);
	file_read.get_byte_array((Uint8*)header.pantable,64);
	file_read.get_byte_array((Uint8*)header.voltable,64);

	aux_string=(char*)header.identifier;

	if ( aux_string!="IMPM" ) return LOADER_ERROR_FILE_FORMAT_NOT_RECOGNIZED;
	if ( file_read.eof_reached() ) return LOADER_ERROR_HEADER_CORRUPT;
	if ( file_read.error_loading() ) return LOADER_ERROR_FILE_ERROR;

	sample_count=0;

	return FUNCTION_SUCCESS;
}

/*************************************************************
   L O A D    S A M P L E S
**************************************************************/

int Loader_IT::load_samples() {

	int tmp_result = FUNCTION_SUCCESS;
        Uint32 *sample_offset;	
	string aux_string;
	int i;

	(void*)sample_offset=malloc(header.smpnum*4);
	(void*)sample=malloc(sizeof(IT_Sample*)*header.smpnum);

	file_read.seek(0xC0+header.ordnum+header.insnum*4);

	for (i=0;i<header.smpnum;i++) {

         	file_read.get_dword(sample_offset[i]);
		sample[i]=new IT_Sample;

		sample[i]->header[4]=0;
		sample[i]->filename[13]=0;
		sample[i]->sampname[29]=0;
	}



	for (i=0;i<header.smpnum;i++) {
	
		file_read.seek(sample_offset[i]);

		file_read.get_byte_array((Uint8*)sample[i]->header,4);
		file_read.get_byte_array((Uint8*)sample[i]->filename,12);
		file_read.get_byte(sample[i]->zerobyte);
		file_read.get_byte(sample[i]->globvol);
		file_read.get_byte(sample[i]->flag);
		file_read.get_byte(sample[i]->volume);
		file_read.get_byte_array((Uint8*)sample[i]->sampname,26);
		file_read.get_byte(sample[i]->convert);	/* sample conversion flag */
		file_read.get_byte(sample[i]->panning);
		file_read.get_dword(sample[i]->length);
		file_read.get_dword(sample[i]->loopbeg);
		file_read.get_dword(sample[i]->loopend);
		file_read.get_dword(sample[i]->c5spd);
		file_read.get_dword(sample[i]->susbegin);
		file_read.get_dword(sample[i]->susend);
		file_read.get_dword(sample[i]->sampoffset);
		file_read.get_byte(sample[i]->vibspeed);
		file_read.get_byte(sample[i]->vibdepth);
		file_read.get_byte(sample[i]->vibrate);
		file_read.get_byte(sample[i]->vibwave);	/* 0=sine, 1=rampdown, 2=square, 3=random (speed ignored) */

		sample[i]->sample_data=NULL;

		sample_count++;
	
		cout << i << "- " << (char*) sample[i]->sampname << endl;

	}

	free(sample_offset);

	if (file_read.eof_reached() || file_read.error_loading()) {

		//[[todo]] Clean up the mess (samples loaded)

		tmp_result = LOADER_ERROR_FILE_ERROR;

	}

	return tmp_result;
}

/* The following sample decompression code is based on xmp's code.(http://xmp.helllabs.org) which is based in openCP's code. */

/*************************************************************
   L O A D    I N S T R U M E N T S
**************************************************************/

int Loader_IT::load_instruments() {

	int tmp_result = FUNCTION_SUCCESS;
        Uint32 *instrument_offset;	
	string aux_string;
	int i;

	(void*)instrument_offset=malloc(header.insnum*4);
	(void*)instrument=malloc(sizeof(IT_Instrument*)*header.insnum);

	file_read.seek(0xC0+header.ordnum);

	for (i=0;i<header.insnum;i++) {

         	file_read.get_dword(instrument_offset[i]);
		instrument[i]=new IT_Instrument;

		instrument[i]->header[4]=0;
		instrument[i]->filename[13]=0;
		instrument[i]->name[29]=0;
	}



	for (i=0;i<header.insnum;i++) {

		int j;
	
		file_read.seek(instrument_offset[i]);

		file_read.get_byte_array((Uint8*)instrument[i]->header,4);	/* (char) Instrument filename */
		file_read.get_byte_array((Uint8*)instrument[i]->filename,12);	/* (char) Instrument filename */
		file_read.get_byte(instrument[i]->zerobyte);		/* (byte) Instrument type (always 0) */
		file_read.get_byte(instrument[i]->nna);			/* New Note Action [0,1,2,3] */
		file_read.get_byte(instrument[i]->dct);			/* Duplicate check type */
		file_read.get_byte(instrument[i]->dca);			/* Duplicate check action */
		file_read.get_word(instrument[i]->fadeout);		/* Envelope end / NNA volume fadeout */
		file_read.get_byte(instrument[i]->ppsep);			/* Pitch-pan Separation */
		file_read.get_byte(instrument[i]->ppcenter);		/* Pitch-pan Center */
		file_read.get_byte(instrument[i]->globvol);
		file_read.get_byte(instrument[i]->chanpan);
		file_read.get_byte(instrument[i]->rvolvar);		/* random volume varations */
		file_read.get_byte(instrument[i]->rpanvar);		/* random panning varations */
		file_read.get_byte_array((Uint8*)instrument[i]->blank01,4);
		file_read.get_byte_array((Uint8*)instrument[i]->name,26);
		file_read.get_byte(instrument[i]->IFC);
		file_read.get_byte(instrument[i]->IFR);
		file_read.get_byte(instrument[i]->midichan);
		file_read.get_byte(instrument[i]->midiprog);
		file_read.get_word(instrument[i]->midibank);

		for (j=0;j<ITNOTECNT;j++) file_read.get_word(instrument[i]->samptable[j]); /* sample for each note [note / samp pairs] */

		file_read.get_byte(instrument[i]->volflg);
		file_read.get_byte(instrument[i]->volpts);
		file_read.get_byte(instrument[i]->volbeg);			/* (byte) Volume loop start (node) */
		file_read.get_byte(instrument[i]->volend);			/* (byte) Volume loop end (node) */
		file_read.get_byte(instrument[i]->volsusbeg);		/* (byte) Volume sustain begin (node) */
		file_read.get_byte(instrument[i]->volsusend);		/* (byte) Volume Sustain end (node) */

		for (j=0;j<ITENVCNT;j++) {

			file_read.get_byte(instrument[i]->volnode[j]);
			file_read.get_word(instrument[i]->voltick[j]);
		}


		file_read.get_byte(instrument[i]->panflg);
		file_read.get_byte(instrument[i]->panpts);
		file_read.get_byte(instrument[i]->panbeg);			/* (byte) channel loop start (node) */
		file_read.get_byte(instrument[i]->panend);			/* (byte) channel loop end (node) */
		file_read.get_byte(instrument[i]->pansusbeg);		/* (byte) channel sustain begin (node) */
		file_read.get_byte(instrument[i]->pansusend);		/* (byte) channel Sustain end (node) */

		for (j=0;j<ITENVCNT;j++) {

			file_read.get_byte(instrument[i]->pannode[j]);
			file_read.get_word(instrument[i]->pantick[j]);
		}


		file_read.get_byte(instrument[i]->pitflg);
		file_read.get_byte(instrument[i]->pitpts);
		file_read.get_byte(instrument[i]->pitbeg);			/* (byte) pitch loop start (node) */
		file_read.get_byte(instrument[i]->pitend);			/* (byte) pitch loop end (node) */
		file_read.get_byte(instrument[i]->pitsusbeg);		/* (byte) pitch sustain begin (node) */
		file_read.get_byte(instrument[i]->pitsusend);		/* (byte) pitch Sustain end (node) */

		for (j=0;j<ITENVCNT;j++) {

			file_read.get_byte(instrument[i]->pitnode[j]);
			file_read.get_word(instrument[i]->pittick[j]);
		}


//		Uint8	volenv[200];	     /* volume envelope (IT 1.x stuff) */
//		Uint8	oldvoltick[ITENVCNT];/* volume tick position (IT 1.x stuff) */

		instrument_count++;
		cout << i << "- " << (char*) instrument[i]->name << endl;

	}

	free(instrument_offset);

	if (file_read.eof_reached() || file_read.error_loading()) {

		//[[todo]] Clean up the mess (samples loaded)
		tmp_result = LOADER_ERROR_FILE_ERROR;
	}

	return tmp_result;
}

/*************************************************************
   L O A D    P A T T E R N D A T A
**************************************************************/

int Loader_IT::load_patterns() {

	int tmp_result = FUNCTION_SUCCESS;

        Uint32 *pattern_offset;	
	int i;

	(void*)pattern_offset=malloc(header.patnum*4);
	(void*)pattern=malloc(sizeof(Pattern*)*header.patnum);

	file_read.seek(0xC0+header.ordnum+header.insnum*4+header.smpnum*4);

	for (i=0;i<header.patnum;i++) {

         	file_read.get_dword(pattern_offset[i]);
		pattern[i]=new Pattern;
	}



	for (i=0;i<header.patnum;i++) {

		Uint16 pat_size;
		Uint16 pat_length;
	
		if (pattern_offset[i]==0) {

			pattern[i]->set_length(64);

			cout << " found an empty pattern at pos " << i << endl;

		} else {
			
			int row=0,flag,channel,j;
			Uint8 aux_byte;
			Uint32 reserved;
			Uint8 chan_mask[64];
			Note last_value[64];
			
			for (j=0;j<64;j++) {
	
				chan_mask[j]=0;
				last_value[j].clear();
			}

			file_read.seek(pattern_offset[i]);

			file_read.get_word(pat_size);
			file_read.get_word(pat_length);
			file_read.get_dword(reserved);
			//[[TODO check for corrupt data
			cout << " found a " << pat_length << " rows pattern at pos " << i << endl;

			pattern[i]->set_length(pat_length);

			do {

				file_read.get_byte(aux_byte);
				flag=aux_byte;

				if ( flag==0 ) {

					row++;
				} else {

					channel=(flag-1) & 63;
			
					if ( flag & 128 ) {

						file_read.get_byte(aux_byte);
						chan_mask[channel]=aux_byte;
					}
						
				
					if ( chan_mask[channel]&1 ) { // read note
				
						file_read.get_byte(aux_byte);
						
						if ( aux_byte<120 ) pattern[i]->get_note_ref(channel,row).note=aux_byte+1;
						else if ( aux_byte==255 ) pattern[i]->get_note_ref(channel,row).note=129;
						else if ( aux_byte==254 ) pattern[i]->get_note_ref(channel,row).note=129;
						else pattern[i]->get_note_ref(channel,row).note=0;

						last_value[channel].note=pattern[i]->get_note_ref(channel,row).note;
					}
						
	
					if ( chan_mask[channel]&2 ) {
	
						file_read.get_byte(aux_byte);
						if ( aux_byte<100 ) pattern[i]->get_note_ref(channel,row).controller_set=aux_byte;
						else pattern[i]->get_note_ref(channel,row).controller_set=0;

						last_value[channel].controller_set=pattern[i]->get_note_ref(channel,row).controller_set;
					}
					if ( chan_mask[channel]&4 ) {
	
						file_read.get_byte(aux_byte);
						if ( aux_byte<65 ) pattern[i]->get_note_ref(channel,row).volume=aux_byte;
						else pattern[i]->get_note_ref(channel,row).volume=65;

						last_value[channel].volume=pattern[i]->get_note_ref(channel,row).volume;
					}
					if ( chan_mask[channel]&8 ) {
	
						file_read.get_byte(aux_byte);
						if ( aux_byte<213 ) pattern[i]->get_note_ref(channel,row).command=aux_byte;
						else pattern[i]->get_note_ref(channel,row).command=0;
						last_value[channel].command=pattern[i]->get_note_ref(channel,row).command;

						file_read.get_byte(aux_byte);
						pattern[i]->get_note_ref(channel,row).parameter=aux_byte;
						last_value[channel].parameter=pattern[i]->get_note_ref(channel,row).parameter;
					}

					if ( chan_mask[channel]&16 ) {
	
						pattern[i]->get_note_ref(channel,row).note=last_value[channel].note;
					}

					if ( chan_mask[channel]&32 ) {
	
						pattern[i]->get_note_ref(channel,row).controller_set=last_value[channel].controller_set;
					}
					if ( chan_mask[channel]&64 ) {
	
						pattern[i]->get_note_ref(channel,row).volume=last_value[channel].volume;
					}
					if ( chan_mask[channel]&128 ) {
	
						pattern[i]->get_note_ref(channel,row).command=last_value[channel].command;
						pattern[i]->get_note_ref(channel,row).parameter=last_value[channel].parameter;
					}

				}
			} while(row<pat_length);

		}

		pattern_count++;
	}

	free(pattern_offset);

	if (file_read.eof_reached() || file_read.error_loading()) {

		//[[todo]] Clean up the mess (samples loaded)

		tmp_result = LOADER_ERROR_FILE_ERROR;

	}

	return tmp_result;
}



/*************************************************************
   C L E A N   U P
**************************************************************/


void Loader_IT::clear_structs(bool p_clear_shared_data) {
	
	int i;

	for (i=0;i<sample_count;i++) {
	
		if ( p_clear_shared_data && (sample[i]->sample_data!=NULL) ) free(sample[i]->sample_data);
		delete sample[i];
	}

	for (i=0;i<instrument_count;i++) {
	
		delete instrument[i];
	}

	for (i=0;i<pattern_count;i++) {
	
		delete pattern[i];
	}

}


int Loader_IT::give_up_and_clear_structs(int p_reason) {

	clear_structs(true);

	return p_reason;
}

/*************************************************************
   O V E R R I D E N    F U N C T I O N S
**************************************************************/


int Loader_IT::transfer_data_to_song() {

	int i,j,k,l;
	bool found_note;
	int current_track=-1;
	int current_column,old_column;
	// Header
	song->reset();
       	// static variables
	
       	song->info.name=header.songname;

        song->speed.tempo=header.inittempo;
		
// [[todo]] read message		
//		Uint16	special;	/* bit 0 set = song message attached */
//		Uint16	msglength;
//		Uint32	msgoffset;


	// Samples
/*
	for (i=0;i<sample_count;i++) {

		song->get_sample(i)->name=sample[i]->sampname;
		song->get_sample(i)->def_volume=sample[i]->volume;
		song->get_sample(i)->glb_volume=sample[i]->globvol;
		song->get_sample(i)->def_panning_on=sample[i]->panning & 128;
		song->get_sample(i)->def_panning=sample[i]->panning & 127;
		song->get_sample(i)->vibrato_type=sample[i]->vibwave;
		song->get_sample(i)->vibrato_speed=sample[i]->vibspeed;
		song->get_sample(i)->vibrato_depth=sample[i]->vibdepth;
		song->get_sample(i)->vibrato_rate=sample[i]->vibrate;
		song->get_sample(i)->base_speed=sample[i]->c5spd;
		song->get_sample(i)->size=sample[i]->length;
		song->get_sample(i)->loop_flags=sample[i]->flag >> 4;
		song->get_sample(i)->loop_begin=sample[i]->loopbeg;
		song->get_sample(i)->loop_end=sample[i]->loopend;
		song->get_sample(i)->sustain_loop_begin=sample[i]->susbegin;
		song->get_sample(i)->sustain_loop_end=sample[i]->susend;
		song->get_sample(i)->sample_ptr=sample[i]->sample_data;
		song->get_sample(i)->format=(sample[i]->flag >> 1) & 1;
		song->get_sample(i)->in_use=sample[i]->flag & IT_SAMPLE_EXISTS;

	}

	for (i=0;i<instrument_count;i++) {

		int j;

		song->get_instrument(i)->name=instrument[i]->name;

		song->get_instrument(i)->filename=instrument[i]->filename;
		song->get_instrument(i)->NNA_type=instrument[i]->nna;
		song->get_instrument(i)->duplicate_check_type=instrument[i]->dct;
		song->get_instrument(i)->duplicate_check_action=instrument[i]->dca;

		for (j=0;j<NOTE_NOTES;j++) {

			song->get_instrument(i)->note_number[j]=instrument[i]->samptable[j*2];
			song->get_instrument(i)->sample_number[j]=instrument[i]->samptable[j*2+1]-1;
		}

		// volume flags
		
		song->get_instrument(i)->volume.global_amount=instrument[i]->globvol;
		song->get_instrument(i)->volume.fadeout=instrument[i]->fadeout;
		song->get_instrument(i)->volume.random_variation=instrument[i]->rvolvar;

		// volume envelope flags

		song->get_instrument(i)->volume.envelope.on=instrument[i]->volflg & 0;
		song->get_instrument(i)->volume.envelope.loop_on=instrument[i]->volflg & 2;
		song->get_instrument(i)->volume.envelope.sustain_loop_on=instrument[i]->volflg & 4;
		song->get_instrument(i)->volume.envelope.loop_begin_node=instrument[i]->volbeg;
		song->get_instrument(i)->volume.envelope.loop_end_node=instrument[i]->volend;
		song->get_instrument(i)->volume.envelope.sustain_loop_begin_node=instrument[i]->volsusbeg;
		song->get_instrument(i)->volume.envelope.sustain_loop_end_node=instrument[i]->volsusend;

		for (j=0;j<instrument[i]->volpts;j++) {
		
			song->get_instrument(i)->volume.envelope.node[j].tick_offset=instrument[i]->voltick[j];
			song->get_instrument(i)->volume.envelope.node[j].value=instrument[i]->volnode[j];
		}

		// panning flags
		
		song->get_instrument(i)->panning.default_amount=instrument[i]->chanpan<65?instrument[i]->chanpan:32;
		song->get_instrument(i)->panning.use_default=instrument[i]->chanpan<65;

		song->get_instrument(i)->panning.random_variation=instrument[i]->rpanvar;
		song->get_instrument(i)->panning.pitch_separation=(Sint8)instrument[i]->ppsep;
		song->get_instrument(i)->panning.pitch_center=instrument[i]->ppcenter;

		// panning envelope flags

		song->get_instrument(i)->panning.envelope.on=instrument[i]->panflg & 0;
		song->get_instrument(i)->panning.envelope.loop_on=instrument[i]->panflg & 2;
		song->get_instrument(i)->panning.envelope.sustain_loop_on=instrument[i]->panflg & 4;
		song->get_instrument(i)->panning.envelope.loop_begin_node=instrument[i]->panbeg;
		song->get_instrument(i)->panning.envelope.loop_end_node=instrument[i]->panend;
		song->get_instrument(i)->panning.envelope.sustain_loop_begin_node=instrument[i]->pansusbeg;
		song->get_instrument(i)->panning.envelope.sustain_loop_end_node=instrument[i]->pansusend;

		for (j=0;j<instrument[i]->panpts;j++) {
		
			song->get_instrument(i)->panning.envelope.node[j].tick_offset=instrument[i]->pantick[j];
			song->get_instrument(i)->panning.envelope.node[j].value=instrument[i]->pannode[j];
		}

		// pitch envelope flags

		song->get_instrument(i)->pitch.envelope.on=instrument[i]->pitflg & 0;
		song->get_instrument(i)->pitch.envelope.loop_on=instrument[i]->pitflg & 2;
		song->get_instrument(i)->pitch.envelope.sustain_loop_on=instrument[i]->pitflg & 4;
		song->get_instrument(i)->pitch.envelope.loop_begin_node=instrument[i]->pitbeg;
		song->get_instrument(i)->pitch.envelope.loop_end_node=instrument[i]->pitend;
		song->get_instrument(i)->pitch.envelope.sustain_loop_begin_node=instrument[i]->pitsusbeg;
		song->get_instrument(i)->pitch.envelope.sustain_loop_end_node=instrument[i]->pitsusend;

		for (j=0;j<instrument[i]->pitpts;j++) {
		
			song->get_instrument(i)->pitch.envelope.node[j].tick_offset=instrument[i]->pittick[j];
			song->get_instrument(i)->pitch.envelope.node[j].value=instrument[i]->pitnode[j];
		}

// [[TODO]] midi stuff
//		song->get_instrument(i)-> =instrument[i]-> ;
		
	
	} */

	//patterndata



	cout << " set variables " << endl;

	for (j=0;j<pattern_count;j++) song->set_pattern_length(j,pattern[j]->get_length());

	for (j=0;j<32;j++) {
		char track_name[11]={'C','h','a','n','n','e','l',' ','0','0',0};
              	song->add_track(1);		
		track_name[8]='0'+j/10;	
		track_name[9]='0'+j%10;	
		song->get_instrument(j)->name=track_name;

		for (i=0;i<pattern_count;i++) {

			for (k=0;k<pattern[i]->get_length();k++) {

//				song->get_track(j)->pattern[i]->column[0]->get_ref_note(k)=pattern[i]->column[j]->get_note(k);
//				song->get_track(j)->pattern[i]->column[0]->get_ref_note(k).controller_set=0;
			}
		}
	}

/* loading mode.. supposed to be smart.. but it's not!

	cout << " copy stuff " << endl;

	for (i=1;i<99;i++) { // all instruments

		found_note=false;

		for (k=0;k<64;k++) { // all columns
	
			for (j=0;j<pattern_count;j++) {

				for (l=0;l<pattern[j]->length();l++) {

					if (pattern[j]->column[k]->get_note(l).controller_set==i) {

						if (!found_note) {

                                                 	song->add_track(1);
							current_column=0;
							current_track++;
							found_note=true;
							old_column=k;
						}

						if (old_column!=k) {

							song->get_track(current_track)->add_column();
							current_column++;
							old_column=k;
						}

						if (j<MAX_PATTERNS_PER_TRACK) {

							song->get_track(current_track)->pattern[j]->column[current_column]->get_ref_note(l)=pattern[j]->column[k]->get_note(l);
							song->get_track(current_track)->pattern[j]->column[current_column]->get_ref_note(l).controller_set=0;
						}

					}		          		
				}
			}
		}
	}


*/

	// Instruments

	return FUNCTION_SUCCESS;
}

int Loader_IT::import_it(const char *p_filename) {

	if (song==NULL) return -1;

        int aux_result;

	if ( file_read.is_open() ) return LOADER_ERROR_LOADER_IN_USE;
	if ( file_read.open(p_filename) ) return LOADER_ERROR_CANNOT_OPEN_FILE;

       	sample_count=0;
	instrument_count=0;
	pattern_count=0;

	if ( (aux_result=load_header()) ) return give_up_and_clear_structs(aux_result);
	if ( (aux_result=load_samples()) ) return give_up_and_clear_structs(aux_result);
	if ( (aux_result=load_instruments()) ) return give_up_and_clear_structs(aux_result);
	if ( (aux_result=load_patterns()) ) return give_up_and_clear_structs(aux_result);
	
	transfer_data_to_song();

	clear_structs(true);

	file_read.close();

	return FUNCTION_SUCCESS;
}


