/***************************************************************************
                          effect_special.h  -  description
                             -------------------
    begin                : Wed Oct 17 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "effect.h"
#include "event_basic.h"



class Effect_Special : public Effect  {

	Uint8 note,volume,command,parameter;


public:

	void notify_command(Uint8 p_parameter) {

		if (p_parameter!=0) {

			command=p_parameter>>4;
			parameter=p_parameter&0xF;				

		}
	}
	int notify_begin(Uint8 p_note,Uint8 p_volume,Uint8 p_old_note) {

		int return_val=PROCESS_NOTE|PROCESS_COMMAND;
                note=p_note;
		volume=p_volume;

		switch (command) {

			case 0xD: {

				if (note<128) return_val=PROCESS_COMMAND;
							
			} break;
		}

		return return_val;
	}

       	void process(int p_time_amount,int p_time_offset) {

		if (p_time_amount!=p_time_offset) return; // no need for extra processing

		switch (command) {
			case 0x1: {
				Event_Pitch_Relative *pitch_event = new Event_Pitch_Relative;
				float disp=0x2000/data->song->get_instrument(track)->midi.PBS.get();
				disp*=parameter;
				disp=0-disp;
                                pitch_event->set_pitch_displacement(disp);		
				queue->push(0,track,column,pitch_event);
			} break;
			case 0x2: {
				Event_Pitch_Relative *pitch_event = new Event_Pitch_Relative;
				float disp=0x2000/data->song->get_instrument(track)->midi.PBS.get();
				disp*=parameter;
                                pitch_event->set_pitch_displacement(disp);		
				queue->push(0,track,column,pitch_event);
			} break;

			case 0xD: {
				if (note>=128) break;
				float delay=data->variables.real_increment;
				delay/=12;
				delay*=parameter;
			        Event_NoteOn *noteon_event = new Event_NoteOn;
				noteon_event->set_note(note,volume);
				queue->push((int)delay,track,column,noteon_event);

			} break;
			case 0xC: {
				float delay=data->variables.real_increment;
				delay/=12;
				delay*=parameter;
			        Event_NoteOff *noteoff_event = new Event_NoteOff;
				noteoff_event->set_volume(64);
				queue->push((int)delay,track,column,noteoff_event);

			} break;

		}		
	}

	Effect_Special() {
		processing=true;
	}
};

