/***************************************************************************
                          interface_callbacks_popups.cpp  -  description
                             -------------------
    begin                : Thu Dec 21 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"
#include "loader_it.h"

void Interface::popup_pattern_properties_confirm() {

	player->stop();
	tracker.editor.set_pattern_properties(
		song->get_abs_pattern(tracker.editor.get_cursor_y()),
		popup_pattern_properties->spinbutton_highlight_major->get_value_as_int(),
		popup_pattern_properties->spinbutton_highlight_minor->get_value_as_int(),
		popup_pattern_properties->spinbutton_highlight_extra->get_value_as_int(),
		popup_pattern_properties->spinbutton_pattern_length->get_value_as_int(),
		popup_pattern_properties->spinbutton_pattern_extra->get_value_as_int()
	);
	

	delete popup_pattern_properties;
	tracker.queue_draw();
}
void Interface::popup_scale_volume_confirm() {

	tracker.editor.selection_volume_scale(popup_volume_scale->spinbutton_volume_scale->get_value_as_int());
	delete popup_volume_scale;	

}

void Interface::popup_window_file() {

	window_file_popup = new Window_File_Popup;

	window_file_popup->button_popup_file_save_as.clicked.connect(slot(this,&Interface::popup_window_file_save_pressed));
        window_file_popup->button_popup_file_new.clicked.connect(slot(this,&Interface::popup_window_file_new_pressed));
        window_file_popup->button_popup_file_load.clicked.connect(slot(this,&Interface::popup_window_file_load_pressed));
        window_file_popup->button_popup_file_export_midi.clicked.connect(slot(this,&Interface::popup_window_file_export_midi_pressed));
        window_file_popup->button_popup_file_save_current.clicked.connect(slot(this,&Interface::popup_window_file_save_current_pressed));
	window_file_popup->button_popup_file_quit.clicked.connect(slot(this,&Interface::popup_window_file_quit));

}

void Interface::popup_window_file_quit() {

	quit_requested=true;	
	player->reset();

}


void Interface::popup_window_file_export_midi_pressed() {

	fileselection_device_load = new Gtk::FileSelection("Export MIDI format 0 file");
	fileselection_device_load->set_position(GTK_WIN_POS_CENTER);
	fileselection_device_load->set_modal(true);
	fileselection_device_load->show();
	fileselection_device_load->get_cancel_button()->clicked.connect(slot(this,&Interface::fileselection_device_load_cancel));
	fileselection_device_load->get_ok_button()->clicked.connect(slot(this,&Interface::popup_window_file_fileselection_export_midi));
}

void Interface::popup_window_file_fileselection_export_midi() {

	string aux_string;

	aux_string=fileselection_device_load->get_filename();

	if ((aux_string.length()>0) && (aux_string[aux_string.length()-1]!='/')) {

	
		Midi_File_Export exporter;
	
		exporter.export_midi(song,aux_string);

                delete fileselection_device_load;
		delete window_file_popup;
	}

}

void Interface::popup_window_file_save_current_pressed() {

	if (current_filename!="") {

		file_operation.save_song(current_filename);
		delete window_file_popup;
	} else {

		popup_window_file_save_pressed();
	}
}

void Interface::popup_window_file_save_pressed() {

	fileselection_device_load = new Gtk::FileSelection("Save File");
	fileselection_device_load->set_position(GTK_WIN_POS_CENTER);
	fileselection_device_load->set_modal(true);
	fileselection_device_load->show();
	fileselection_device_load->get_cancel_button()->clicked.connect(slot(this,&Interface::fileselection_device_load_cancel));
	fileselection_device_load->get_ok_button()->clicked.connect(slot(this,&Interface::popup_window_file_fileselection_save));
}

void Interface::popup_window_file_load_pressed() {

	fileselection_device_load = new Gtk::FileSelection("Load File");
	fileselection_device_load->set_position(GTK_WIN_POS_CENTER);
	fileselection_device_load->set_modal(true);
	fileselection_device_load->show();
	fileselection_device_load->get_cancel_button()->clicked.connect(slot(this,&Interface::fileselection_device_load_cancel));
	fileselection_device_load->get_ok_button()->clicked.connect(slot(this,&Interface::popup_window_file_fileselection_load));
}

void Interface::popup_window_file_fileselection_save() {

	string aux_string;

	aux_string=fileselection_device_load->get_filename();

	if ((aux_string.length()>0) && (aux_string[aux_string.length()-1]!='/')) {
		
		current_filename=aux_string;
		file_operation.save_song(aux_string);

                delete fileselection_device_load;
		delete window_file_popup;
	}


}

void Interface::popup_window_file_fileselection_load() {

	string aux_string;

	aux_string=fileselection_device_load->get_filename();

	if ((aux_string.length()>0) && (aux_string[aux_string.length()-1]!='/')) {
	
		Loader_IT it_loader;
		player->stop();

		if ( (aux_string.substr(aux_string.length()-3,3)==".it") || (aux_string.substr(aux_string.length()-3,3)==".IT") ) {

                 	it_loader.link_to_song(song);
			it_loader.import_it(aux_string.c_str());

		} else {
                        file_operation.load_song(aux_string);
			current_filename=aux_string;
		}

		reset_interface();
		player->reset();

                delete fileselection_device_load;
		delete window_file_popup;
	}


}

void Interface::popup_window_file_new_pressed() {

	song->reset();
	song->user_devices.add_device();
	song->user_devices.get_device(0)->name="Null Output";
	song->user_devices.get_device(0)->hardware_device_index=0;
	reset_interface();
	player->reset();
	delete window_file_popup;
}

void Interface::popup_variables_ok_pressed() {


	
	song->get_instrument(selected_track)->initial_value=variables_popup->value_list;

	delete variables_popup;
	request_update_track_properties(selected_track);

}