
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_schedule.h
**  Date:    June 3, 2002
**
**  Author:  Brian Wotring
**  Purpose: deal with sheduling tasks for the management daemon.
**
******************************************************************************/

#ifndef MD_SCHEDULE_H_
#define MD_SCHEDULE_H_

#define SCHEDULE_PERIOD_SECONDS  30
#define SCHEDULE_PERIOD_USECONDS  0

#define INCOMING_SCHEDULE_EVENT()   ( FD_ISSET( schedule_pipe[0], &read_set ) )

fd_set read_set;

typedef struct OSI_SCHEDULE
{
    char host[MAX_HOSTNAME_LENGTH];

    unsigned long start;    /* timevalue of when to start scanning */
    unsigned long period;   /* interval after start time to conduct scans. */

} OSI_SCHEDULE;


THREAD_FUNCTION_TYPE md_scheduler_run( void *unused );

void md_scheduler_wait();
void md_schedules_check( osi_list schedules );
osi_list md_schedules_read();

void initialize_scheduling_signals();
void scheduling_signal_handler( int signal );

void md_schedules_signal_updated();

#endif

