
/******************************************************************************
**
**  Copyright (C) 2001  - the shmoo group -
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/******************************************************************************
**
**    The Shmoo Group (TSG)
**
**    File:      filter_script.c
**    Author:    Brian Wotring
**
**    Date:      March 14, 2002.
**    Project:   osiris
**
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include <sys/stat.h>

#include "utilities.h"
#include "scan_record.h"
#include "filter.h"

osi_bool filter_script( const char *file_path, FILTER_CONTEXT *context )
{
    char number[25] = "\0";
    int length = 0;

    if( ( file_path != NULL ) && ( context != NULL ) )
    {
        if( context->file_handle == NULL )
        {
            context->file_handle = osi_fopen( file_path, "r", 0 );
        }

        else
        {
            fseek( context->file_handle, 0, SEEK_SET );
        }

        if( context->file_handle != NULL )
        {
            length = fread( number, 1, 25, context->file_handle );

            if( length == 25 )
            {
                /* shell archive or script for antique kernel text */

                if( strncmp( number, ": ", 2 ) == 0 )
                    return TRUE;
            
                /* awk script text */
            
                if( strncmp( number, "BEGIN", 5 ) == 0 )
                    return TRUE;
            
                /* for non scripts, bail now. */
            
                if( strncmp( number, "#!", 2 ) == 0 )
                {
                    /* look for shell scripts. */
            
                    if( strstr( number, "/bin/sh" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/bin/csh" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/usr/local/bin/bash" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/bin/bash" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/bin/ksh" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/bin/tcsh" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/usr/local/tcsh" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/usr/local/bin/tcsh" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/usr/local/bin/zsh" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/usr/local/bin/ash" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/usr/local/bin/ae" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/bin/nawk" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/usr/bin/nawk" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/usr/local/bin/nawk" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/bin/gawk" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/usr/bin/gawk" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/usr/local/bin/gawk" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/bin/awk" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/usr/bin/awk" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/bin/rc" ) != 0 )
                    {
                        return TRUE;
                    }
                
                    if( strstr( number, "/usr/bin/env" ) != 0 )
                    {
                        return TRUE;
                    }
                }
            }
        }
    }

    return FALSE;
}
