/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import org.javagroups.log.Trace;
import org.javagroups.util.ReusableThread;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ThreadPool {
    int MAX_NUM;
    int current_index;
    ReusableThread[] pool;
    boolean[] available_threads;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReusableThread getThread() {
        ReusableThread retval = null;
        ReusableThread[] reusableThreadArray = this.pool;
        synchronized (this.pool) {
            int i = 0;
            while (true) {
                if (i >= this.current_index) {
                    if (this.current_index < this.MAX_NUM) break;
                    Trace.error("ThreadPool.getThread()", "could not create new thread because pool's max size reached (" + this.MAX_NUM + ") !");
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return null;
                }
                ReusableThread tmp = this.pool[i];
                if (tmp.available()) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return tmp;
                }
                ++i;
            }
            retval = new ReusableThread();
            this.pool[this.current_index++] = retval;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return retval;
        }
    }

    public void destroy() {
        this.deletePool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ReusableThread[] reusableThreadArray = this.pool;
        synchronized (this.pool) {
            ret.append("ThreadPool: capacity=" + this.pool.length + ", index=" + this.current_index + '\n');
            ret.append("Threads are:\n");
            int i = 0;
            while (true) {
                if (i >= this.current_index) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return ret.toString();
                }
                ret.append("[" + i + ": " + this.pool[i] + "]\n");
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void deletePool() {
        ReusableThread[] reusableThreadArray = this.pool;
        synchronized (this.pool) {
            int i = 0;
            while (true) {
                if (i >= this.MAX_NUM) {
                    this.current_index = 0;
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return;
                }
                ReusableThread t = this.pool[i];
                if (t != null) {
                    t.stop();
                    this.pool[i] = null;
                }
                ++i;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.MAX_NUM = 255;
        this.current_index = 0;
        this.pool = null;
        this.available_threads = null;
    }

    public ThreadPool(int max_num) {
        this.this();
        this.MAX_NUM = max_num;
        this.pool = new ReusableThread[this.MAX_NUM];
        this.available_threads = new boolean[this.MAX_NUM];
        int i = 0;
        while (i < this.pool.length) {
            this.pool[i] = null;
            this.available_threads[i] = true;
            ++i;
        }
    }
}

