/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.io.DataInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Vector;

public class McastSenderTest1_4 {
    public static void main(String[] args) {
        MulticastSocket[] sockets = null;
        InetAddress mcast_addr = null;
        InetAddress bind_addr = null;
        byte[] buf = new byte[]{};
        int ttl = 32;
        AckReceiver ack_receiver = null;
        boolean use_all_interfaces = false;
        int port = 5555;
        try {
            int i = 0;
            while (i < args.length) {
                String tmp = args[i];
                if (tmp.equals("-help")) {
                    McastSenderTest1_4.help();
                    return;
                }
                if (tmp.equals("-bind_addr")) {
                    bind_addr = InetAddress.getByName(args[++i]);
                } else if (tmp.equals("-mcast_addr")) {
                    mcast_addr = InetAddress.getByName(args[++i]);
                } else if (tmp.equals("-ttl")) {
                    ttl = Integer.parseInt(args[++i]);
                } else if (tmp.equals("-port")) {
                    port = Integer.parseInt(args[++i]);
                } else if (tmp.equals("-use_all_interfaces")) {
                    use_all_interfaces = true;
                } else {
                    McastSenderTest1_4.help();
                    return;
                }
                ++i;
            }
            if (mcast_addr == null) {
                mcast_addr = InetAddress.getByName("224.0.0.150");
            }
            if (use_all_interfaces && !McastSenderTest1_4.is1_4()) {
                System.err.println("-use_all_interfaces flag requires JDK 1.4 or greater");
                return;
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            return;
        }
        try {
            MulticastSocket sock;
            if (use_all_interfaces) {
                Vector<InetAddress> v = new Vector<InetAddress>();
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> e2 = intf.getInetAddresses();
                    while (e2.hasMoreElements()) {
                        bind_addr = e2.nextElement();
                        v.addElement(bind_addr);
                    }
                }
                sockets = new MulticastSocket[v.size()];
                int i = 0;
                while (i < v.size()) {
                    sock = new MulticastSocket(port);
                    sock.setTimeToLive(ttl);
                    sock.setInterface((InetAddress)v.elementAt(i));
                    sockets[i] = sock;
                    ack_receiver = new AckReceiver(sock);
                    ack_receiver.start();
                    ++i;
                }
            } else {
                sockets = new MulticastSocket[]{new MulticastSocket(port)};
                sockets[0].setTimeToLive(ttl);
                if (bind_addr != null) {
                    sockets[0].setInterface(bind_addr);
                }
                ack_receiver = new AckReceiver(sockets[0]);
                ack_receiver.start();
            }
            int i = 0;
            while (i < sockets.length) {
                sock = sockets[i];
                if (sock != null) {
                    System.out.println("Socket #" + (i + 1) + '=' + sock.getLocalAddress() + ':' + sock.getLocalPort() + ", ttl=" + sock.getTimeToLive() + ", bind interface=" + sock.getInterface());
                }
                ++i;
            }
            DataInputStream in = new DataInputStream(System.in);
            while (true) {
                System.out.print("> ");
                String line = in.readLine();
                if (line.startsWith("quit") || line.startsWith("exit")) {
                    System.exit(0);
                }
                buf = line.getBytes();
                DatagramPacket packet = new DatagramPacket(buf, buf.length, mcast_addr, port);
                McastSenderTest1_4.send(packet, sockets);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    static void send(DatagramPacket packet, MulticastSocket[] sockets) {
        if (packet == null || sockets == null) {
            return;
        }
        int i = 0;
        while (i < sockets.length) {
            try {
                if (sockets[i] != null) {
                    sockets[i].send(packet);
                }
            }
            catch (Exception ex) {
                System.err.println("McastSenderTest1_4.send(): " + ex);
            }
            ++i;
        }
    }

    static boolean is1_4() {
        try {
            Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass("java.net.NetworkInterface");
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static void help() {
        System.out.println("McastSenderTest1_4 [-bind_addr <bind address>] [-help] [-mcast_addr <multicast address>] [-port <multicast port that receivers are listening on>] [-ttl <time to live for mcast packets>] [-use_all_interfaces]");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class AckReceiver
    implements Runnable {
        DatagramSocket sock;
        DatagramPacket packet;
        byte[] buf;
        Thread t;

        public void run() {
            while (this.t != null) {
                try {
                    this.buf = new byte[256];
                    this.packet = new DatagramPacket(this.buf, this.buf.length);
                    this.sock.receive(this.packet);
                    System.out.println("<< Received packet from " + this.packet.getAddress().getHostAddress() + ':' + this.packet.getPort() + ": " + new String(this.packet.getData()));
                }
                catch (Exception e) {
                    System.err.println(e);
                    break;
                }
            }
            this.t = null;
        }

        void start() {
            this.t = new Thread((Runnable)this, "McastSenderTest1_4.AckReceiver thread");
            this.t.start();
        }

        void stop() {
            if (this.t != null && this.t.isAlive()) {
                this.t = null;
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private final /* synthetic */ void this() {
            this.t = null;
        }

        AckReceiver(DatagramSocket sock) {
            this.this();
            this.sock = sock;
        }
    }
}

