/*
 * supp-srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/srmv2/supp-srmv2.h,v 1.13 2002/02/03 03:05:47 lim Exp $
 */


#ifndef srmv2_supp_h
#define srmv2_supp_h

#ifndef Bool
#define Bool int
#endif
#include "srmv2/srmv2.h"
#include "srmv2/session-srmv2.h"
#define SRMv2_CANCEL 0
#define SRMv2_BACKOFF 1


class SRMv2_ReqQueue;


class SRMv2_Edge {
public:
	unsigned int adu;
	unsigned int byte;
	SRMv2_Edge() : adu(0), byte(0) {}
	SRMv2_Edge(unsigned int a, unsigned int b)
		: adu(a), byte(b) {}
	SRMv2_Edge(const SRMv2_Edge& e) {
		adu = e.adu;
		byte = e.byte;
	}
	void set_edge(unsigned int a, unsigned int b) {
		adu = a;
		byte = b;
	}
	void advance(Bool eoa) {
		if (!eoa) {
			byte++;
		} else {
			adu++;
			byte = 0;
		}
	}
	inline Bool operator==(const SRMv2_Edge &e) {
		return (e.adu == adu && e.byte == byte);
	}
	inline Bool operator<=(const SRMv2_Edge &e) {
		return ((adu < e.adu) || (adu == e.adu && byte <= e.byte));
	}
	Bool operator<(const SRMv2_Edge &e) {
		return ((adu < e.adu) || (adu == e.adu && byte < e.byte));
	}
};


class SRMv2_Signature {
public:
	SRMv2_Signature() : childsig(0) { }
	unsigned int childsig; /* 32-bit representation of signatures of
				* all children (for leaf nodes, this is 0) */
	SRMv2_Edge edge;

	void set(unsigned int c, unsigned int a, unsigned int b) {
		childsig = c;
		edge.set_edge(a, b);
	}
	
	inline Bool operator==(const SRMv2_Signature &s) {
		return (s.childsig == childsig && edge == s.edge);
	}
};


class SRMv2_Request : public SRMv2_Timer {
public:
	SRMv2_Request(unsigned int cid, const SRMv2_Edge& l,
		      const SRMv2_Edge& r) : 
		left(l), right(r), next(0), 
		cid_(cid), ttl_(INIT_TTL), 
		backoff_level_(0) {}

	SRMv2_Request(SRMv2_Request& r) : 
		left(r.left), right(r.right), 
		next(0), cid_(r.cid_), ttl_(INIT_TTL) {}

	SRMv2_Request(unsigned int cid, unsigned int a1=SRMv2_CEND, 
		      unsigned int b1=SRMv2_CEND, unsigned int a2=SRMv2_CEND, 
		      unsigned int b2=SRMv2_CEND) {
	  ttl_ = INIT_TTL;
	  cid_ = cid;
	  left.set_edge(a1, b1);
	  right.set_edge(a2, b2);
	}
	~SRMv2_Request() {
		cancel();
	}
	inline Bool valid() {
		return (left < right);
	}
	inline Bool empty() {
		return (left == right);
	}
	inline Bool operator==(const SRMv2_Request &rg) {
		return (cid_ == rg.cid_ && left==rg.left  &&  right==rg.right);
	}
	void sched_timeout(double ms, SRMv2_Session *s, SRMv2_Source *src) {
		period_ = ms;
		if (s) 
			session_ = s;
		source_ = src;
		msched((int) period_);
	}
	void backoff();
	void send_request();
	void send_reply();

	void send_nsrequest();
	void send_nsreply();

	void source(SRMv2_Source* s)   { source_ = s; }
	void queue(SRMv2_ReqQueue* q)  { queue_ = q; }
	void session(SRMv2_Session* s) { session_ = s; }
	void uaddr(unsigned int u)     { uaddr_ = u; }
	void display() { 
		srm_trace(srmSRM, ("\t RNG: %d %d.%d--%d.%d (Q 0x%p)",
				   cid_, left.adu, left.byte, right.adu,
				   right.byte, this));
	}
	SRMv2_Source*   source()  { return source_; }
	SRMv2_ReqQueue* queue()   { return queue_; }
	SRMv2_Session*  session() { return session_; }
	unsigned int    uaddr()   { return uaddr_; }
	
	SRMv2_Edge      left, right;
	SRMv2_Request*  next;
	unsigned int    cid_;
	unsigned int    uaddr_; /* unicast address to reply to, in 
				   case of a reply. */
	unsigned int    ttl_;
	double          period_; /* in ms */
	unsigned int    backoff_level_; 
	SRMv2_Source*   source_;
	SRMv2_Session*  session_;
	SRMv2_ReqQueue* queue_;

protected:
	void timeout();
};

class SRMv2_ReqQueue {
public:
	SRMv2_ReqQueue() : list_(0) {}
	void schedule(SRMv2_Request* r);
	void backoff(unsigned int cid, SRMv2_Edge left, SRMv2_Edge right) {
		SRMv2_Request r(cid, left, right);
		intersection(&r, SRMv2_BACKOFF);
	}
	void cancel(u_int cid, SRMv2_Edge& left, 
		    SRMv2_Edge& right, u_short *ttl=0) {
		SRMv2_Request r(cid, left, right);
		intersection(&r, SRMv2_CANCEL, ttl);
	}
	virtual void send(SRMv2_Request *request) {
		request->send_request();
	}

protected:
	SRMv2_Request *list_;

	void insert(SRMv2_Request *range, SRMv2_Request *pos);
	void insert(SRMv2_Request *range);	
	void process(SRMv2_Request *prev, Bool flag, u_short *ttl);
	void dodelete(SRMv2_Request *prev);
	void append_cpy(SRMv2_Request *range, SRMv2_Request *head);	
	void append(SRMv2_Request *range, SRMv2_Request *head);	
	void append(SRMv2_Request *range);
	void intersection(SRMv2_Request *r, Bool flag, u_short *ttl=0);
};

class SRMv2_RepQueue : public SRMv2_ReqQueue {

public:
	void send(SRMv2_Request *r) {
		r->send_reply();
	}
};

class SRMv2_NSReqQueue : public SRMv2_ReqQueue {

public:
	void send(SRMv2_Request *r) {
		r->send_nsrequest();
	}
};

class SRMv2_NSRepQueue : public SRMv2_ReqQueue {

public:
	void send(SRMv2_Request *r) {
		r->send_nsreply();
	}
};

#endif

