/*
 * tgmb-chunk.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_TGMB_CHUNK_H
#define MASH_TGMB_CHUNK_H

#include "mb/mb.h"
#include "tgmb-enum.h"
#include "mb/mb-nethost.h"

class PageItem;


class ChunkFrag {
public:
	ChunkFrag(TclObject *destination) : data_(NULL),
	  destination_(destination) {
		flush();
	}
	~ChunkFrag() { flush(); }

	Bool insert_props(const PageItem *item);
	void insert_any(ChunkFragDescr descr, void *data, int len);
	void insert(ChunkFragDescr descr, u_int32_t value);
	void insert(ChunkFragDescr descr, u_int16_t value);
	void insertCoords(ChunkFragDescr descr, Point *points,
			  int numPoints);

	void replace_any(ChunkFragDescr descr, void *data, int len);

	void get_props(PageItem *item);
	Bool get(ChunkFragDescr descr, u_int16_t &value);
	Bool get(ChunkFragDescr descr, u_int32_t &value);
	Bool get_any(ChunkFragDescr descr, void *&ptr, u_int16_t &len);
	Bool find(ChunkFragDescr descr);
	void flush();
	void flush_data();

	Bool is_valid() { return Bool(hdr_.cmd_!=cmdInvalid); }

	struct Header {
		u_int32_t canvCmdId_;
		SrcId     srcId_;
		u_int32_t cmd_;
		u_int32_t len_;
	} hdr_;
	u_char *data_;
	TclObject *destination_;

private:
	u_char *allocate_entry(ChunkFragDescr descr, int len);
};




inline void host2net(const ChunkFrag::Header &host, ChunkFrag::Header &net) {
	net.canvCmdId_ = host2net(host.canvCmdId_);
	host2net(host.srcId_, net.srcId_);
	net.cmd_ = host2net(host.cmd_);
	net.len_ = host2net(host.len_);
}



inline void net2host(const ChunkFrag::Header &net, ChunkFrag::Header &host) {
	host.canvCmdId_ = net2host(net.canvCmdId_);
	net2host(net.srcId_, host.srcId_);
	host.cmd_ = net2host(net.cmd_);
	host.len_ = net2host(net.len_);
}


template<class T>
inline Bool renew(T *&pointer, size_t origLen, size_t newLen) {
	T *newPtr;

	newPtr = new T [newLen];
	if (!newPtr) return FALSE;
	if (pointer) {
		if (origLen < newLen) {
			memcpy(newPtr, pointer, origLen);
		} else {
			memcpy(newPtr, pointer, newLen);
		}
		delete [] pointer;
	}
	pointer = newPtr;
	return TRUE;
}


#endif  /* MASH_TGMB_CHUNK_H */
