/*
 * tgmb-conn.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tgmb-conn.h,v 1.6 2002/02/03 04:17:39 lim Exp $
 */

#ifndef MASH_TGMB_CONN_H
#define MASH_TGMB_CONN_H


#include <NetMgr.h>
#include "tgmb-defs.h"

#define sizeof_WingmanHdr 20

struct WingmanHdr {
	DWord version;      /* Protocol version */
	DWord requestID;    /* The request id */
	DWord metadataSize; /* How much metadata has been sent */
	DWord dataSize;     /* How much data has been sent */
	DWord comp;         /* compression (unused) */
};


#define ENDFRAG VoidPtr(NULL)

struct Chunk {
public:
	Chunk() { Reset(); }
	~Chunk(){ }
	void Reset() { MemSet(this, sizeof(Chunk), 0); }
	void SetHeader(Long reqId, ULong metaSize, ULong dataSize)
	{
		hdr.version      = TGMB_VERSION;
		hdr.requestID    = reqId;
		hdr.metadataSize = metaSize;
		hdr.dataSize     = dataSize;
		hdr.comp         = 0;
	}

	void *CreateAndLock(VoidHand &handle, ULong size);
	void *Lock(VoidHand handle) { return MemHandleLock(handle); }
	void Unlock(VoidHand handle) { MemHandleUnlock(handle); }
	void Free(VoidHand handle) { MemHandleFree(handle); }
	Word InsertFrag(void *dest, Word descr, Word value);
	Word InsertAnyFrag(void *destVoidPtr, Word descr, ...);
	void *GetFrag(void *data, Word &descr, VoidPtr &ptr, Word &size);

	WingmanHdr hdr;
	VoidHand   dataHandle, metadataHandle;
	ULong      dataID, metadataID;
};


class TGMB_Socket {
public:
	TGMB_Socket() { Reset(); };
	virtual ~TGMB_Socket();

	Boolean Connect(const char *host, UShort port,
			NetSocketTypeEnum type=netSocketTypeStream);
	Boolean Disconnect();
	Boolean IsConnected() { return Boolean(sock_!=-1); }

	void GetAddress(NetIPAddr *local,  Word *lport,
			NetIPAddr *remote, Word *rport);
	virtual void Receive()=0;
protected:
	virtual void Reset();

	// data members
	NetSocketRef sock_;
};


class TGMB_Connection : public TGMB_Socket {
public:
	TGMB_Connection() : db_(NULL) {Reset();}
	virtual ~TGMB_Connection();
	Err DestroyChunk(VoidHand chunkHandle);
	Err Send(Chunk *chunk);

	void DB(DmOpenRef db) { db_ = db; }
	DmOpenRef DB() { return db_; }

	virtual  void Receive();

	static Word evtBytesReceived_, evtChunkReceived_;
private:
	enum TGMB_ConnectionState {
		connReadingHdr=1,
		connReadingMetadata,
		connReadingData
	};

	virtual  void Reset();
	VoidHand NewDmHandle(DWord size, ULong &id);
	Boolean  CreateNewChunk(Chunk *chunk, VoidPtr hdrBuf);
	Err      DestroyChunk(Chunk *chunk);

	void Error();
	void NotifyBytesReceived(DWord numberOfBytes);
	void NotifyChunkReceived();

	// sending stuff
	DWord    nextRequest_;

	// receiving stuff
	UChar    recvHdrBuf_[sizeof_WingmanHdr];
	Chunk    chunk_;
	TGMB_ConnectionState state_;
	DWord    readSoFar_;

	DmOpenRef db_;
};


class AS1_Connection : public TGMB_Socket {
public:
	AS1_Connection() : port_(0), rmxPort_(0), timerId_(Word(-1)) {
			StrCopy(sessionAddr_,TGMB_DEFAULT_Session);
	}
	Boolean Start();
	void Stop();
	void Timeout();
	virtual void Receive();
	void Send();
	const char *SessionAddr() { return sessionAddr_; }
	void SessionAddr(const char *sessionAddr);
private:
	char ipAddr_[TGMB_MAXADDRSPEC],
		sessionAddr_[TGMB_MAXADDRSPEC+TGMB_MAXPORTSPEC+5];
	Word port_, rmxPort_;
	Word timerId_;
	Word noResponse_;
};


struct EvtBytesReceived {
	DWord bytes;
	TGMB_Connection *conn;
};


struct EvtChunkReceived {
	VoidHand chunkHandle;
	TGMB_Connection *conn;
};


#endif /* #ifdef MASH_TGMB_CONN_H */
