/*
 * tg-hash.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tg-hash.h,v 1.4 2002/02/03 04:17:39 lim Exp $
 */

#ifndef MASH_TG_HASH_H
#define MASH_TG_HASH_H


struct TG_Pointer {
	TG_Pointer() : handle((VoidHand)0xFFFF), offset(0xFFFF) { }
	Boolean IsNull() { return ((handle==(VoidHand)0xFFFF
				    && offset==0xFFFF) ? true:false); }
	void SetNull() { handle = (VoidHand) 0xFFFF; offset = 0xFFFF; }

	VoidHand handle;
	Word offset;
};


struct TG_HashChunkInfo;


/* Hashtable key sizes MUST be multiples of 4 */
class TG_HashTable {
public:
	TG_HashTable() { }
	~TG_HashTable() { }

	void  Open(DmOpenRef db, Word sizeofKey, ULong firstChunk=0xFFFFFFFF);
	ULong Close(Boolean deleteAllEntries=1);
	void  Insert(void *key, TG_Pointer *ptr);
	Boolean Delete(void *key, TG_Pointer *ptr=NULL) {
		return FindUpdateDelete(key, ptr, htDelete);
	}
	Boolean Find(void *key, TG_Pointer *ptr=NULL) {
		return FindUpdateDelete(key, ptr, htFind);
	}
	Boolean Update(void *key, TG_Pointer *ptr) {
		return FindUpdateDelete(key, ptr, htUpdate);
	}

private:
	enum FindUpdateDeleteType { htFind, htUpdate, htDelete };
	Boolean FindUpdateDelete(void *key, TG_Pointer *ptr,
				 FindUpdateDeleteType what);
	ULong CreateNewChunk(Word maxEntries);
	void Grow();
	void Hash(void *key, DWord &h1, DWord &h2);
	void LocateChunk(DWord bucketNo, Word &idx, Word &offset);
	Boolean IsKeyEmpty(void *key) {
		Byte *bytes=(Byte*)key;
		for (Word i=0; i<sizeofKey_; i++, bytes++)
			if (*bytes != 0xFF) return 0;
		return 1;
	}
	Boolean IsPtrEmpty(void *bucket) {
		Byte *bytes=((Byte*)bucket)+sizeofKey_;
		for (Word i=0; i<sizeof(TG_Pointer); i++, bytes++)
			if (*bytes != 0xFF) return 0;
		return 1;
	}
	inline Boolean Match(void *k1, void *k2) {
		BytePtr p1=(BytePtr)k1, p2=(BytePtr)k2;
		for (Word i=0; i<sizeofKey_; i++) {
			if (*p1++ != *p2++) return false;
		}
		return true;
	}

	inline Word SizeofHashEntry() {return sizeofKey_+sizeof(TG_Pointer);}
	DWord numEntries_;      // total number of used entries in the HT
	DWord deletedEntries_;  // total number of deleted entries in the HT
				// (# active entries = #used - #deleted)
	DWord maxEntries_;      // max number of entries possible in HT
	Word  sizeofKey_;
	Word primesArrayIndex_;

	TG_HashChunkInfo *chunks_; // info about db records that hold the HT
	ULong firstChunkId_;    // unique id of the first chunk
	Word numChunks_, maxChunks_;
	DmOpenRef db_;
};


#endif /* #ifdef MASH_TG_HASH_H */
