/*
 * tg-app.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tg-app.h,v 1.5 2002/02/03 04:17:39 lim Exp $
 */

#ifndef MASH_TG_APP_H
#define MASH_TG_APP_H


#include <Pilot.h>
#include <NetMgr.h>
#include <sys/socket.h>
#include <netinet_in.h>


#define MAX_SOCKETS netFDSetSize
#define MAX_TIMERS  4

class TG_Application {
public:
	TG_Application() : timeout_(evtWaitForever) { }
	virtual ~TG_Application() { }

	DWord Run();

	virtual DWord Init() { return 0; }
	virtual DWord Cleanup() { return 0; }
	virtual DWord EventLoop();
	virtual DWord ServiceIdle() { return 0; };
	virtual Boolean HandleEvent(EventPtr /*ePtr*/) { return true; }

	SDWord EvtLoopTimeout() { return timeout_; }
	void   EvtLoopTimeout(SDWord timeout) { timeout_ = timeout; }
protected:
	SDWord timeout_;
};


class TG_NetworkApplication : public TG_Application {
public:
	TG_NetworkApplication(Word selectEventType, Word timeoutEventType);
	virtual DWord Init();
	virtual DWord Cleanup();

	virtual DWord ServiceIdle() { return PollNetwork(); };

	void RegisterSocket(NetSocketRef socket, VoidPtr clientData) {
		netFDSet(socket, &readFDs_);
		clientData_[socket] = clientData;
		if (socket > maxSocketID_) maxSocketID_ = socket;
	}
	void UnregisterSocket(NetSocketRef socket) {
		netFDClr(socket,&readFDs_);
		clientData_[socket] = NULL;
		if (socket >= maxSocketID_) {
			NetSocketRef i, max=0;
			for (i=0; i<=maxSocketID_; i++) {
				if (netFDIsSet(i, &readFDs_)) max = i;
			}
			maxSocketID_ = i;
		}
	}
	VoidPtr GetSocketClientData(NetSocketRef socket) {
		if (socket>=0 &&
		    socket < (NetSocketRef) (sizeof(clientData_) /
		    sizeof(clientData_[0]))) {
			return clientData_[socket];
		} else {
			return NULL;
		}
	}

	DWord  NetLibOpen();
	DWord  NetLibClose();
	inline Boolean NetLibOpened() { return netLibOpen_; }
	DWord  ConnectionRefresh();

        NetSocketRef Connect(const char *addr_str,
			     NetSocketTypeEnum type=netSocketTypeStream);
        NetSocketRef Connect(const char *host, UShort port,
			     NetSocketTypeEnum type=netSocketTypeStream);
        DWord Disconnect(NetSocketRef sock);
	SWord Receive(NetSocketRef sock, VoidPtr buf, Word size);
	SWord DmReceive(NetSocketRef sock, VoidPtr buf, Word offset,
			Word size);
	Err Send(NetSocketRef sock, VoidPtr buf, Word len);

	Word RegisterTimer(ULong after, VoidPtr clientData);
	void UnregisterTimer(Word id);

	inline void Error(const char *str) { error_ = str; }
	inline const char *Error() const { return error_; }

	static DWord GetLocalIP();
	static Word AppNetRefnum;
	static SDWord AppNetTimeout;
private:
	DWord PollNetwork();

	NetFDSetType readFDs_;
	NetSocketRef maxSocketID_;
        Boolean netLibOpen_;
	Word selectEventType_, timerEventType_;
	VoidPtr clientData_[MAX_SOCKETS];
	struct Timer {
		Timer() : id(0), timeout(0), clientData(NULL) {}
		Word id;
		ULong timeout;
		VoidPtr clientData;
	} timers_[MAX_TIMERS];
	Word lastTimerId_;

	const char *error_;
};


struct EvtNetSelect {
	NetSocketRef sock;
	VoidPtr clientData;
};


struct EvtTimeout {
	Word timerId;
	VoidPtr clientData;
};


inline void TG_GetUsrEvtObject(EventPtr evPtr, VoidPtr usrPtr, Word size) {
	if (size > sizeof(evPtr->data.generic))
		size = sizeof(evPtr->data.generic);
	MemMove(usrPtr, &evPtr->data.generic, size);
}


inline void TG_AddUsrEventToQueue(SWord evType, VoidPtr descr, Word size) {
	EventType evt;
	MemSet(&evt, sizeof(EventType), 0);
	evt.eType = (enum events) evType;
	if (descr!=NULL && size > 0) {
		if (size > sizeof(evt.data.generic))
			size = sizeof(evt.data.generic);
		MemMove(&evt.data.generic, descr, sizeof(evt.data.generic));
	}
	EvtAddEventToQueue(&evt);
}


inline void TG_AddUsrUniqueEventToQueue(SWord evType, DWord id,
					VoidPtr descr, Word size)
{
	EventType evt;
	MemSet(&evt, sizeof(EventType), 0);
	evt.eType = (enum events) evType;
	if (descr!=NULL && size > 0) {
		if (size > sizeof(evt.data.generic))
			size = sizeof(evt.data.generic);
		MemMove(&evt.data.generic, descr, sizeof(evt.data.generic));
	}
	EvtAddUniqueEventToQueue(&evt, id, true);
}


inline void *TG_FrmGetObjectPtr(FormPtr frm, Word id) {
        return FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, id));
}

Boolean TG_FldSetText(FieldPtr fld, CharPtr val, ULong len=(ULong)-1);
Boolean TG_FldSetText(FieldPtr fld, ULong val);


inline FieldPtr TG_FrmGetFocusObjectPtr(FormPtr frm)
{
        Word focus = FrmGetFocus(frm);
        if (focus == noFocus) return NULL;
        return (FieldPtr) FrmGetObjectPtr(frm, focus);
}


inline CharPtr TG_StrNCopy(CharPtr dst, const Char* src, Word n) {
        StrNCopy(dst, src, n-1);
	dst[n-1] = '\0';
	return dst;
}


inline void TG_Debug(CharPtr str, SWord x, SWord y) {
	WinDrawChars(str, StrLen(str), x, y);
}


#endif /* #ifdef MASH_TG_APP_H */
