# main.tcl --
#
#       This is the main entry point for the setup tool (the Mash installer).
#       Tcl source code expansion with tcl-expand.tcl starts here.
#       Tcl execution also starts here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/setup/main.tcl,v 1.14 2002/02/11 23:04:58 lim Exp $


import WidgetClass
WidgetClass transparent_gif

import Setup Setup/Mash


option add *MessageBox*Label.font [WidgetClass widget_default -font]
option add *MessageBox*Label.wrapLength 0


# Hide the root window offscreen so it's not visible.  We can't just withdraw or
# iconify it because, on Windows, that will also withdraw/iconify all the
# transient windows used by the Setup program.  Unfortunately, we have to force
# a window update and then reposition it offscreen because some Unix window
# managers adjust the positions of windows when they first appear.
#
label .label -text {Starting up...}
pack .label -fill both -expand true
set x [expr int([winfo screenwidth .] / 2)]
set y [expr int([winfo screenheight .] / 2)]
wm geometry . +$x+$y
update idletasks
.label configure -text {Running...}
set x [expr [winfo screenwidth .] + 32]
set y [expr [winfo screenheight .] + 32]
wm geometry . +$x+$y


# source the config file if it is specified on the command line
if { $argv != {} } {
	# don't put "source $file" on a line by itself
	# otherwise, tcl-expand will get confused and try to source the
	# file right away!
	foreach file $argv { source $file }
}

# search for a subclass of Setup; if found create an instance of the subclass
# else create an instance of Setup

set cls [lindex [Setup info subclass] 0]
if { $cls=={} } { set cls Setup }

[new $cls] run

