# sm-rtpgw.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/rtpgw/sm-rtpgw.tcl,v 1.11 2002/02/03 04:29:18 lim Exp $

import MediaAgent Source/RTP

Class MediaAgent/RTPGW -superclass MediaAgent

# In principle we would want to attach the agent to the source manager
# for each session.  The problem is that the agent muct receive the
# event before it's passed to the sessions.  Since the attachment API
# does not guarantee dispachment order, we explicitly do it as follows.

MediaAgent/RTPGW instproc init { agent } {
	$self next

	$self set agent_ $agent
}

MediaAgent/RTPGW instproc create-source { srcid ssrc addr srcsess } {
	$self instvar agent_
	set src [new Source/RTP $self $srcid $ssrc $addr]
	$src set session_ $srcsess

	$self instvar sources_
	lappend sources_ $src
	$agent_ register $src

	$self notify_observers register $src

	return $src
}

MediaAgent/RTPGW instproc activate src {
	$self instvar agent_
	$agent_ activate $src

	$self next $src
}

MediaAgent/RTPGW instproc deactivate src {
	$self instvar agent_
	$agent_ deactivate $src

	$self next $src
}

MediaAgent/RTPGW instproc trigger_format src {
	$self instvar agent_
	$agent_ trigger_format $src

	$self next $src
}

MediaAgent/RTPGW instproc unregister src {
	$self instvar agent_
	$agent_ unregister $src

	$self next $src

	$agent_ check_for_sources
}
