# fca-mgr.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# SRMAppMgr/FCA is defined in C++


Class SRMAppMgr/FCA/Tcl -superclass SRMAppMgr/FCA
DbgOut "SRMAppMgr/FCA: [SRMAppMgr/FCA info superclass]"

SRMAppMgr/FCA/Tcl instproc init { policy moderatorIds } {
    # data members:
    #   session_ fcPolicy_ fcDynamics_ rcvrs_ localSrcId_
    #
    $self next
    $self instvar fcPolicy_ moderatorIds_
    set fcPolicy_ $policy
    $fcPolicy_ print
    set moderatorIds_ $moderatorIds
}


SRMAppMgr/FCA/Tcl instproc fcPolicy {} {
    return [$self set fcPolicy_]
}


SRMAppMgr/FCA/Tcl instproc localSrcId {} {
    return [$self set localSrcId_]
}


SRMAppMgr/FCA/Tcl instproc create_dynamics { } {
    $self instvar fcPolicy_ fcDynamics_ moderatorIds_ localSrcId_

    if { ![info exists localSrcId_] || $localSrcId_=={} } {
	error "SRMAppMgr/FCA/Tcl create_dynamics should be called only after\nthe local source has been attached"
    }

    if { [$self localIsModerator] } {
	set class FCAFloorDynamics/Moderator
    } else {
	set class FCAFloorDynamics
    }

    set fcDynamics_ [new $class $self $fcPolicy_ $moderatorIds_]
}


SRMAppMgr/FCA/Tcl instproc session {} {
    $self instvar session_
    return $session_
}


# need to call this function attach_session_, since $self next does not work
# with methods defined inside the command() method of TclObjects
SRMAppMgr/FCA/Tcl instproc attach_session_ { session } {
    $self instvar session_
    set session_ $session
    $self attach_session $session
}


SRMAppMgr/FCA/Tcl instproc attach_uiMgr { uiMgr } {
    $self instvar uiMgr_
    set uiMgr_ $uiMgr
}


SRMAppMgr/FCA/Tcl instproc uiMgr { } {
    return [$self set uiMgr_]
}


SRMAppMgr/FCA/Tcl instproc setLocalSrcId { localSrcId } {
    $self instvar localSrcId_
    set localSrcId_ $localSrcId
}


SRMAppMgr/FCA/Tcl instproc isModerator {sid} {
    $self instvar moderatorIds_
    DbgOut "Searching for moderator $sid in $moderatorIds_"
    set i [lsearch $moderatorIds_ $sid]
    if { $i == -1 } {
	return 0
    } else {
	return 1
    }
}


SRMAppMgr/FCA/Tcl instproc localRcvr {} {
    $self instvar rcvrs_ localSrcId_
    return $rcvrs_($localSrcId_)
}

SRMAppMgr/FCA/Tcl instproc getRcvr {srcId} {
    $self instvar rcvrs_
    if {[info exist rcvrs_($srcId)]} {
	return $rcvrs_($srcId)
    }
    DbgOut "rcvr for $srcId doesn't exist"
    return ""
}

SRMAppMgr/FCA/Tcl instproc localIsModerator {} {
    $self instvar localSrcId_
    return [$self isModerator $localSrcId_]
}

#SRMAppMgr/FCA/Tcl instproc moderatorRcvr { moderatorSrcId } {
#    $self instvar rcvrs_
#    return $rcvrs_($moderatorSrcId)
#}


SRMAppMgr/FCA/Tcl instproc fcDynamics {} {
    $self instvar fcDynamics_
    return $fcDynamics_
}


# was new_source before
SRMAppMgr/FCA/Tcl instproc define_rcvr { srcId isLocal } {
    $self instvar rcvrs_ fcDynamics_

#    DbgOut "defining $srcId, isModerator = [$self isModerator $srcId]"

    if { ![info exists rcvrs_($srcId)] } {
	# if no rcvr exists
	if { [$self isModerator $srcId] } {
	    if { $isLocal } {
		DbgOut "Creating FCARcvr/Tcl/LocalModerator for $srcId"
		set rcvrs_($srcId) [new FCARcvr/Tcl/LocalModerator \
			$self $srcId]
	    } else {
		DbgOut "Creating FCARcvr/Tcl/Moderator for $srcId"
		set rcvrs_($srcId) [new FCARcvr/Tcl/Moderator $self $srcId]
	    }
	} else {
	    if { $isLocal } {
		DbgOut "Creating FCARcvr/Tcl/Local for $srcId"
		set rcvrs_($srcId) [new FCARcvr/Tcl/Local $self $srcId]
	    } else {
		DbgOut "Creating FCARcvr/Tcl for $srcId"
		set rcvrs_($srcId) [new FCARcvr/Tcl $self $srcId]
	    }
	}
    }
#else {
#	DbgOut "SRMAppMgr/FCA/Tcl::define_rcvr, moderators are : \
#		[[$self fcDynamics] set moderatorIds_]"
#    }
#    DbgOut "SRMAppMgr/FCA/Tcl::define_rcvr, $srcId, return $rcvrs_($srcId), \
#	    of class [$rcvrs_($srcId) info class]"
    return $rcvrs_($srcId)
}
