# dc-servicetableentry.tcl --
#
#       table containing info received from the SDS services, including
#       attributes and how to contact the services
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# g_iUpdateTime - the initial time for an table entry.  The higher this number
# is, the longer it takes for a device to timeout
#

global g_iUpdateTime
set g_iUpdateTime 3

#
# Class CServiceTableEntry
#
# Data structure for the table entry.
#
Class CServiceTableEntry

CServiceTableEntry instproc init {source iCid contactInfo serviceProperty} {
    global g_iUpdateTime
    $self instvar m_source m_iCid m_contactInfo m_iTime m_serviceProperty

    set m_source $source
    set m_iCid $iCid
    set m_iTime $g_iUpdateTime
    set m_contactInfo $contactInfo
    set m_serviceProperty $serviceProperty
}

CServiceTableEntry instproc UpdateTime {} {
    global g_iUpdateTime
    $self instvar m_iTime

    set m_iTime $g_iUpdateTime
}

# access function
CServiceTableEntry instproc Source {{source {}}} {
    $self instvar m_source

    set oldSource $m_source
    if {$source != {}} {	set m_source $source  }
    return $oldSource
}

CServiceTableEntry instproc Cid {{iCid {}}} {
    $self instvar m_iCid

    set oldiCid $m_iCid
    if {$iCid != {}} { set m_iCid $iCid }
    return $oldiCid
}

CServiceTableEntry instproc Time {{iTime {}}} {
    $self instvar m_iTime

    set oldiTime $m_iTime
    if {$iTime != {}} { set m_iTime $iTime }
    return $oldiTime
}

CServiceTableEntry instproc ContactInfo {{contactInfo {}}} {
    $self instvar m_contactInfo

    set oldContactInfo $m_contactInfo
    if {$contactInfo != {}} { set m_contactInfo $contactInfo }
    return $oldContactInfo
}

CServiceTableEntry instproc ServiceProperty {{serviceProperty {}}} {
    $self instvar m_serviceProperty

    set oldServiceProperty $m_serviceProperty
    if {$serviceProperty != {}} { set m_serviceProperty $serviceProperty }
    return $oldServiceProperty
}
