/*
 * cues-bitmaps.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CUES_BITMAPS_H
#define CUES_BITMAPS_H

#include "sm_ear.xbm"
#include "lg_ear.xbm"
#include "sm_hand.xbm"
#include "lg_hand.xbm"
#include "sm_quest.xbm"
#include "lg_quest.xbm"
#include "sm_yes.xbm"
#include "lg_yes.xbm"
#include "sm_no.xbm"
#include "lg_no.xbm"

void
Cues_LoadBitmaps(Tcl_Interp* tcl)
{
        Tk_DefineBitmap(tcl, Tk_GetUid("sm_ear"),
			sm_ear_bits, sm_ear_width, sm_ear_height);
        Tk_DefineBitmap(tcl, Tk_GetUid("lg_ear"),
			lg_ear_bits, lg_ear_width, lg_ear_height);
        Tk_DefineBitmap(tcl, Tk_GetUid("sm_hand"),
			sm_hand_bits, sm_hand_width, sm_hand_height);
        Tk_DefineBitmap(tcl, Tk_GetUid("lg_hand"),
			lg_hand_bits, lg_hand_width, lg_hand_height);
        Tk_DefineBitmap(tcl, Tk_GetUid("sm_quest"),
			sm_quest_bits, sm_quest_width, sm_quest_height);
        Tk_DefineBitmap(tcl, Tk_GetUid("lg_quest"),
			lg_quest_bits, lg_quest_width, lg_quest_height);
        Tk_DefineBitmap(tcl, Tk_GetUid("sm_yes"),
			sm_yes_bits, sm_yes_width, sm_yes_height);
        Tk_DefineBitmap(tcl, Tk_GetUid("lg_yes"),
			lg_yes_bits, lg_yes_width, lg_yes_height);
        Tk_DefineBitmap(tcl, Tk_GetUid("sm_no"),
			sm_no_bits, sm_no_width, sm_no_height);
        Tk_DefineBitmap(tcl, Tk_GetUid("lg_no"),
			lg_no_bits, lg_no_width, lg_no_height);
}

#endif
