# nam-node.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#------------------------------------------------
#
#
Class AnmObj/NamNode -superclass AnmObj

AnmObj/NamNode instproc init {eId st et nodeId pos size {shape rect}} {
        $self next $eId

        $self instvar rect_ textLoc_
        set x0 [expr [lindex $pos 0] - $size/2.0]
        set y0 [expr [lindex $pos 1] - $size/2.0]
        set x1 [expr [lindex $pos 0] + $size/2.0]
        set y1 [expr [lindex $pos 1] + $size/2.0]
        set rect_ [list $x0 $y0 $x1 $y1]

        $self set nodeId_ $nodeId
        $self set shape_ $shape
        $self set size_ $size
        $self set textLoc_ [list [expr $x0 + 0.2*$size] [expr $y0 + 0.2*$size]]
        # DbgOut Node [$self get_id] is $self

        # insert more space for packets and labels
        set gap [expr $size * 2]
        $self set bbox_ [list [expr $x0 - $gap] [expr $y0 - $gap] \
                        [expr $x1 + $gap] [expr $y1 + $gap]]
}

# other node shapes not implemented yet.
AnmObj/NamNode instproc draw {now} {
#        $self instvar drawboard_ x0_ y0_ x1_ y1_ nodeId_ size_ textX_ textY_
        eval [$self set drawboard_] rect [$self set rect_] black
        eval [$self set drawboard_] text [$self set textLoc_] 1 [$self set nodeId_]
}

