# al-ns.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/sim/hm/al-ns.tcl,v 1.4 2002/02/03 04:16:36 lim Exp $ (UCB)

Class AnnounceListenManager

AnnounceListenManager instproc init { mtu spec } {
	$self next

	$self instvar sess_
	set spec [split $spec /]
	set addr [lindex $spec 0]
	set port [lindex $spec 1]
	global ns
	set sess_ [$ns session $addr/$port 10]
	$sess_ join $self
}

AnnounceListenManager instproc destroy {} {
	$self instvar sess_
	$sess_ leave $self

	$self next
}

AnnounceListenManager instproc start { active } {
	$self instvar timer_ active_
	set active_ $active
	$timer_ schedule_timer
}

AnnounceListenManager instproc stop {} {
	$self instvar timer_ active_
	set active_ 0
	$timer_ cancel
}

AnnounceListenManager instproc send_announcement {} {
	$self instvar timer_ active_
	if { $active_ == 1 } {
		set data [$self build_announcement]
		$self announce $data
#puts ""
#puts "$self ($class): announce {$data}"
#puts ""
	}
	$timer_ schedule_timer
}

AnnounceListenManager instproc announce { msg } {
	$self instvar sess_
	$sess_ send $self $msg
}

AnnounceListenManager instproc recv { from msg size } {
	set addr [[$from set agent_] set host_]
	$self recv_announcement $addr $msg $size
}
