/*
 * session-rtpgw.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/rtp/session-rtpgw.cc,v 1.14 2002/02/03 04:15:47 lim Exp $";
#endif

#include "ntp-time.h"
#include "session-rtp.h"
#include "source.h"
#include "module.h"

class RTPGWSession : public RTP_Session, public MultiInputManager {
public:
	virtual int command(int argc, const char*const* argv);
	/* FIXME This should eventually migrate to Transmitter */
	virtual void recv(CtrlHandler* ch);
	virtual void recv_data(pktbuf* pb) {
		Transmitter::recv(pb);
	}
	virtual void recv_ctrl(pktbuf* pb) {
		transmit_ctrl(pb);
		pb->release();
	}
	virtual void send_report(CtrlHandler* ch, int, int);
protected:
	RTPGWSession() : dih_(0), cih_(0) {}
private:
	DataInputHandler* dih_;
	ControlInputHandler* cih_;
};

class VideoRTPGWSession : public RTPGWSession {
public:
	virtual int check_format(int fmt) const;
};

class AudioRTPGWSession : public RTPGWSession {
public:
	virtual int check_format(int fmt) const;
};

class VideoRTPGWSessionClass : public TclClass {
public:
	VideoRTPGWSessionClass() : TclClass("Session/RTP/RTPGW/Video") {}
	TclObject* create(int, const char*const*) {
		return (new VideoRTPGWSession);
	}
} vgw_class;

class AudioRTPGWSessionClass : public TclClass {
public:
	AudioRTPGWSessionClass() : TclClass("Session/RTP/RTPGW/Audio") {}
	TclObject* create(int, const char*const*) {
		return (new AudioRTPGWSession);
	}
} agw_class;

int VideoRTPGWSession::check_format(int fmt) const
{
	switch(fmt) {
	case RTP_PT_CELLB:
	case RTP_PT_JPEG:
	case RTP_PT_CUSEEME:
	case RTP_PT_NV:
	case RTP_PT_CPV:
	case RTP_PT_H261:
	case RTP_PT_PVH:
	case RTP_PT_H261_COMPAT:/*FIXME*/
		return (1);
	}
	return (0);
}

int AudioRTPGWSession::check_format(int fmt) const
{
	switch (fmt) {
	case RTP_PT_PCMU:
	case RTP_PT_CELP:
	case RTP_PT_GSM:
	case RTP_PT_DVI:
	case RTP_PT_LPC:
		return (1);
	}
	return (0);
}

/*
 * Receive an rtcp packet (from the control port).
 */
void RTPGWSession::recv(CtrlHandler* ch)
{
	static u_int8_t buf[2*RTP_MTU];
	u_int32_t src;
	int port;
	int cc = ch->recv(buf, sizeof buf, src, port);
	if (cc <= 0)
		return;

	rtcphdr* rh = (rtcphdr*)buf;
	if (cc < int(sizeof(*rh))) {
		++nrunt_;
		return;
	}
	/*
	 * try to filter out junk: first thing in packet must be
	 * sr, rr or bye & version number must be correct.
	 */
	switch(ntohs(rh->rh_flags) & 0xc0ff) {
	case RTP_VERSION << 14 | RTCP_PT_SR:
	case RTP_VERSION << 14 | RTCP_PT_RR:
	case RTP_VERSION << 14 | RTCP_PT_BYE:
		break;
	default:
		/*
		 * FIXME should further categorize this error -- it is
		 * likely that people mis-implement applications that
		 * don't put something other than SR,RR,BYE first.
		 */
		++badversion_;
		return;
	}

	ch->sample_size(cc);
	u_int32_t addr = src;

	/*
	 * First record in compound packet must be the ssrc of the
	 * sender of the packet.  Pull it out here so we can use
	 * it in the sdes parsing, since the sdes record doesn't
	 * contain the ssrc of the sender (in the case of mixers).
	 */
	u_int32_t ssrc = rh->rh_ssrc;
	Source* ps = sm_->lookup(this, ssrc, ssrc, addr);
	if (ps == 0)
		return;

	int layer = ch - ch_;
	/*
	 * Outer loop parses multiple RTCP records of a "compound packet".
	 * There is no framing between records.  Boundaries are implicit
	 * and the overall length comes from UDP.
	 *
	 * We break up the packet into source-specific packets, i.e.,
	 * into SR and RR headed packets, since the
	 * gateway modifications are on source granularity.  Note that this
	 * is probably pretty rare since this can only happen if a mixer has
	 * been combining SR's and RR's from several sources.
	 */
	u_char* epack = (u_char*)rh + cc;
	rtcphdr* startrh = rh;
	int first = 1;
	u_int len;
	while ((u_char*)rh < epack) {
		len = (ntohs(rh->rh_len) << 2) + 4;
		u_char* ep = (u_char*)rh + len;
		if (ep > epack)
			return;
		u_int flags = ntohs(rh->rh_flags);
		if (flags >> 14 != RTP_VERSION)
			return;
		switch (flags & 0xff) {
		case RTCP_PT_SR:
		case RTCP_PT_RR:
			if (!first) {
				pktbuf* pb = pool_->alloc(layer);
				ssrc = startrh->rh_ssrc;
				ps = sm_->lookup(this, ssrc, ssrc, addr);
				ps->layer(layer).lts_ctrl(unixtime());
				len = (u_char*)rh - (u_char*)startrh;
				bcopy((u_char*)startrh, pb->data, len);
				pb->len = len;
				startrh = rh;
				ps->ctrl_handler()->recv(pb);
			} else
				first = 0;
			break;
		case RTCP_PT_BYE:
			parse_bye(rh, flags, ep, ps);
			break;
		case RTCP_PT_SDES:
		case RTCP_PT_APP:
			break;
		}
		rh = (rtcphdr*)ep;
	}
	/* Last record */
	if ((u_char*)startrh < epack) {
		pktbuf* pb = pool_->alloc(layer);
		ssrc = startrh->rh_ssrc;
		ps = sm_->lookup(this, ssrc, ssrc, addr);
		ps->layer(layer).lts_ctrl(unixtime());
		len = epack - (u_char*)startrh;
		bcopy((u_char*)startrh, pb->data, len);
		pb->len = len;
		ps->ctrl_handler()->recv(pb);
	}
}

void RTPGWSession::send_report(CtrlHandler* ch, int, int)
{
	/*
	 * Don't send anything. Just go through the motions to have a
	 * reasonable report interval estimate for the active source check.
	 */

	/* Only care about layer 0 */
	if (ch != ch_)
		return;

	timeval now = unixtime();

	int nrr = 0;
	int nsrc = 0;

	u_int inactive = u_int(ch->rint() * (32./1000.));
	if (inactive < 2)
		inactive = 2;
	for (Source* sp = sm_->sources(); sp != 0; sp = sp->next_) {
		++nsrc;
		Source::Layer& sl = sp->layer(0);
		int received = sl.np() - sl.snp();
		if (received == 0) {
			if (u_int(now.tv_sec - sl.lts_ctrl().tv_sec) > inactive)
				--nsrc;
			continue;
		}
		if (++nrr >= 31)
			break;
	}

	ch->adapt(nsrc, nrr, 0);
	sm_->CheckActiveSources(ch->rint());
}

int RTPGWSession::command(int argc, const char*const* argv)
{
	/* FIXME this should all go into Transmitter */
	Tcl& tcl = Tcl::instance();
	if (argc == 2) {
		if (strcmp(argv[1], "data-handler") == 0) {
			tcl.resultf("%s", dih_->name());
			return (TCL_OK);
		}
		if (strcmp(argv[1], "ctrl-handler") == 0) {
			tcl.resultf("%s", cih_->name());
			return (TCL_OK);
		}
	}
	if (argc == 3) {
		if (strcmp(argv[1], "data-handler") == 0) {
			dih_ = (DataInputHandler*)TclObject::lookup(argv[2]);
			dih_->manager(this);
			return (TCL_OK);
		}
		if (strcmp(argv[1], "ctrl-handler") == 0) {
			cih_ =
			    (ControlInputHandler*)TclObject::lookup(argv[2]);
			cih_->manager(this);
			return (TCL_OK);
		}
	}
	return (RTP_Session::command(argc, argv));
}
