/*
 * module-rtppkt-logger.cc --
 *
 *      This file contains the definition and methods for the RTPPktLogger
 *      class.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "inet.h"
#include "rtp.h"
#include "rep-decoder.h"
#include "bsd-endian.h"
#include "tclcl.h"
#include "renderer.h"
#include "pktbuf.h"
#include "vidreps.h"
#include "logger.h"

/*
 * The RTPPktLogger class corresponds to the OTcl class
 * Module/RTPPktLogger. This PacketHandler derived class
 * is used to log RTP packets with the global LogService
 * object described in logger.cc. Any packet that arrives
 * on the recv method is logged with the LogService and
 * simply forward to the next target.
 */

class RTPPktLogger : public PacketHandler {
public:
  RTPPktLogger() : PacketHandler(sizeof(rtphdr)) {};

  virtual void recv(pktbuf *pb);
};

/*
 * Recv entry method for RTP packets.
 */

void
RTPPktLogger::recv(pktbuf *pb)
{
  logger.log_rtp_pkt(pb);
  if (target_ != 0) {
    target_->recv(pb);
  } else {
    pb->release();
  }
}

/*
 * Binding between C++ class RTPPktLogger and
 * OTcl class "Module/RTPPktLogger"
 */

static class RTPPktLoggerClass : public TclClass {
public:
  RTPPktLoggerClass() : TclClass("Module/RTPPktLogger") {}
  TclObject *create(int argc, const char*const* argv) {
    return (new RTPPktLogger());
  }
} swd_rtp_pkt_logger_;

