/*
 * transducer-master.h --
 *
 *      The idea of this class is to have one master transducer that can be
 *      attached to an audio controller or whatever.  Then you can attach
 *      transducers to this master, and the set() calls from the audio
 *      controller are distributed to all the slave transducers.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef VD_TRANSDUCER_MASTER_H
#define VD_TRANSDUCER_MASTER_H

#include "transducer.h"

// FIXME - really don't want a fixed maximum number (though 20 should be
//    more than plenty)
#define MAX_NUM_SLAVES 20

/*
  The idea of this class is to have one master transducer that can be attached
  to an audio controller or whatever.  Then you can attach transducers to
  this master, and the set() calls from the audio controller are distributed
  to all the slave transducers

  It supports spoofing.  See command() implementation in transducer-master.cc.
*/

class MasterTransducer : public Transducer {
public:
  MasterTransducer(int argc, const char* const* argv);
  ~MasterTransducer();

  virtual void set(double d);

  virtual int attachTransducer(const char* trans);

  // Tcl interface
  virtual int command(int argc, const char* const* argv);

 private:
  Transducer* slaveTransducers_[MAX_NUM_SLAVES];
  int numSlaves_;

  int useSpoof_;
  double spoofLevel_;
};

#endif

