/*
 * tkwidget.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1993-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/misc/tkwidget.h,v 1.10 2002/02/03 04:11:42 lim Exp $
 */

#ifndef mash_tkwidget_h
#define mash_tkwidget_h

#include "tclcl.h"
extern "C" {
#include <tk.h>
}

extern const char *cszDefaultBG, *cszDefaultFG;

class TkWidget : public TclObject {
    public:
	/* Called when full redraw is needed */
	virtual void draw() = 0;
	/* Called when incremental redraw needed (i.e., no external damage) */
	virtual void update() = 0;

	virtual void resize();
	virtual void handle(const XEvent&);
	void redraw();
        const char* getFg() { return cszDefaultFG; }
        const char* getBg() { return cszDefaultBG; }
        void getforeback(const char* fg, const char* bg,
                         XColor** ppFg, XColor** ppBg) const;
	GC lookup_gc(Font fid, const char* fg, const char* bg) const;
	void set_gcv(XGCValues& v, u_long& mask,
		     Font, XColor* fg, XColor* bg) const;
	XColor* getcolor(const char* name, const char* backup) const;
	inline int mono() const { return (mono_); }
	virtual int command(int argc, const char*const* argv);
	int destroyed();
	virtual void destroy() { destroyed_ = 1; }

    protected:
	TkWidget();
        virtual ~TkWidget();
	void init(const char* path, const char* classname,
		  int reqw, int reqh, u_long extra_events = 0);
	Tk_Window tk_;
	int width_;
	int height_;
	int mono_;
	int destroyed_;
	u_long eventmask_;

    private:
	Pixmap make_stipple(float level) const;
	static void display(ClientData cd);
	static void handle(ClientData cd, XEvent* ep);

	int callback_pending_;
	int damage_;
};
#endif /* mash_tkwidget_h */
