/*
 * audio.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1991-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/audio/audio.h,v 1.16 2002/02/03 03:10:46 lim Exp $
 */


#ifndef mash_audio_h
#define mash_audio_h

#include <sys/types.h>
#ifdef WIN32
#include <io.h>
#else
#include <sys/ioctl.h>
#endif
#include "observe.h"

#include "ss.h"
#include "iohandler.h"
#include "tclcl.h"

class Audio;
class Event;
class VOXProc;
class Filter;
class Tcl;

#define MAXAUDIOSIZE 2048

class AudioHandler {
public:
	virtual void audio_handle() = 0;
};

class Audio : public TclObject, public Observable, public IOHandler {
    public:
	enum {
		mode_mikemutesnet = 0,
		mode_none = 1,
		mode_ec = 2,
		mode_netmutesmike = 3
	};
	Audio();
	virtual ~Audio();
	virtual int command(int argc, const char*const* argv);
	virtual int FrameReady() = 0;
	virtual u_char* Read() = 0;
	virtual	void Write(u_char *) = 0;
	virtual void SetRGain(int);
	virtual void SetPGain(int);
	virtual void InputPort(int);
	inline int InputPort() const { return (iport_); }
	virtual void OutputPort(int);
	inline int OutputPort() const { return (oport_); }
	inline int RGain() const { return (rgain_); }
	inline int PGain() const { return (pgain_); }
	int Silent(const u_char*, int len) const;
	inline int RMuted() const { return (rmute_); }
	inline int PMuted() const { return (pmute_); }
	inline int Mode() const { return (omode_); }
	inline int haveaudio() const { return (fd_ >= 0); }
	virtual void RMute();
	virtual void RUnmute();
	inline void PMute() { pmute_ |= 1; }
	inline void PUnmute() { pmute_ &=~ 1; }

	virtual int RDrops() { return 0; }
	virtual int AdjustTime(u_int) { return 0; }
	virtual void Flush() {}
	virtual int CanFilter() const { return 0; }
	void RetrainFilter(int, int);
	int PlayRec(u_char *, u_char *, int);
	virtual void Release();
	virtual void Obtain();
	virtual int NeedsSilence() const { return 0; }
	inline int GetBlockSize() { return blksize_; }

	inline void handler(AudioHandler* p) { handler_ = p; }

	virtual int SetAudioDevice(int dev);
        virtual int getSampleRate() { return 8000;};
        virtual int use16bits() { return 0;};  // are we using 16 bit sound samples?
        virtual int inStereo() {return 0;}; // are we sending stereo?
protected:
	int lock_fd_;
	void openlock();
	void unlock();
	int lock();

	virtual void dispatch(int mask);
	const u_int blksize_;	/* the number of samples in one block of audio */
	int fd_;		/* file descriptor of hardware audio device */
	int oport_;		/* output port number currently active */
	int iport_;		/* input port number currently active */
	int rmute_;		/* non-zero iff input muted */
	int pmute_;		/* non-zero iff output muted */
	int omode_;		/* speakerphone mode */
	int rgain_, pgain_;	/* input/output gain (0-255) */
	int duplex_;		/* true iff audio device can do full duplex */
	char* input_names_;	/* names of input ports */
	char* output_names_;	/* names of output ports */
	AudioHandler* handler_;
	int device_; // audio device to use (0 for /dev/audio0, etc)
};

#endif
