/*
 * rtp-archive.h --
 *
 *      RTP Archive header file
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef MASH_RTP_ARCHIVE_H
#define MASH_RTP_ARCHIVE_H


#include "archive/timeval.h"
#include "misc/nethost.h"
#include "net/pktbuf.h"

inline u_int32_t adjust_logical2rtp(u_int32_t sec, u_int32_t usec, double scale,
			     u_int32_t ref_rtp, u_int32_t ref_tv_sec,
			     u_int32_t ref_tv_usec, int adjust)
{
	double t = sec + usec/1000000.0,
		ref = ref_tv_sec + ref_tv_usec/1000000.0;
	u_int32_t temp = (u_int32_t) ((t - ref + (double(ref_rtp)/double(scale))) \
			    * scale) ;
	return (u_int32_t) temp + adjust;


}


inline u_int32_t logical2rtp(u_int32_t sec, u_int32_t usec, double scale,
			     u_int32_t ref_rtp, u_int32_t ref_tv_sec,
			     u_int32_t ref_tv_usec)
{
	double t = sec + usec/1000000.0,
		ref = ref_tv_sec + ref_tv_usec/1000000.0;
	return (u_int32_t) ((t - ref + (double(ref_rtp)/double(scale))) \
			    * scale);
}


inline u_int32_t logical2rtp(timeval tv, double scale,
			     u_int32_t ref_rtp, u_int32_t ref_tv_sec,
			     u_int32_t ref_tv_usec)
{
	return logical2rtp(tv.tv_sec, tv.tv_usec, scale, ref_rtp,
			   ref_tv_sec, ref_tv_usec);
}


inline timeval rtp2logical(u_int32_t rtp, double scale, u_int32_t ref_rtp,
			   timeval ref_tv)
{
	timeval tv, diff_tv;
	double diff;
	diff = double(rtp - ref_rtp)/double(scale);
	tv = ref_tv;
	diff_tv.tv_sec = (long int) diff;
	double temp = (diff - diff_tv.tv_sec);
	diff_tv.tv_usec = (long int) (temp * 1000000);
	tv = tv + diff_tv;

	return tv;
}


inline timeval rtp2logical(u_int32_t rtp, double scale, u_int32_t ref_rtp, u_int32_t ref_sec, u_int32_t ref_usec)
{
	timeval temp;
	temp.tv_sec=ref_sec;
	temp.tv_usec=ref_usec;
	return (rtp2logical(rtp, scale, ref_rtp, temp));
}


#if 0 // FIXME: this stuff is being called from anywhere?
inline double get_scale(u_int32_t rtp1, u_int32_t rtp2, u_int32_t ref_sec1, u_int32_t ref_usec1, u_int32_t ref_sec2, u_int32_t ref_usec2) {

	double t = ref_sec1 + ref_usec1/1000000.0;
	double t2 = ref_sec2 + ref_usec2/1000000.0;

	double diff = t2-t;
	double rtp_diff = rtp2 - rtp1;


}
#endif

struct RTPprivatehdr {
	char email[128];
	char phone[64];
	char loc[256]; // geographical user location
	char tool[64]; // application or tool name
	u_int32_t scale;
	u_int32_t ssrc;
	u_int32_t ref_rtp;
	u_int32_t ref_tv_sec;
	u_int32_t ref_tv_usec;
};

struct recordhdr {
	u_int len;
	u_char type;
	u_char d2;
};

class RTPPacket {
public:
	RTPPacket* next;
	u_int seq;  // sequence number, adjusted
	u_int its;  // timestamp  Still necessary?
	u_short type; //Indicates whether it's a data pkt, 0, or ctrl, 0x80
	u_short len; // Length of whole packet, including header
	pktbuf* buf;
};



inline void host2net(const RTPprivatehdr &host, RTPprivatehdr &net) {
	memcpy(&net, &host, sizeof(RTPprivatehdr));
	net.scale = host2net(net.scale);
	net.ssrc = host2net(net.ssrc);
	net.ref_rtp = host2net(net.ref_rtp);
	net.ref_tv_sec  = host2net(net.ref_tv_sec);
	net.ref_tv_usec = host2net(net.ref_tv_usec);
}


inline void net2host(const RTPprivatehdr &net, RTPprivatehdr &host) {
	memcpy(&host, &net, sizeof(RTPprivatehdr));
	host.scale = net2host(host.scale);
	host.ssrc = net2host(host.ssrc);
	host.ref_rtp = net2host(host.ref_rtp);
	host.ref_tv_sec  = net2host(host.ref_tv_sec);
	host.ref_tv_usec = net2host(host.ref_tv_usec);
}


#endif /* MASH_RTP_ARCHIVE_H */
