//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: cobject.h,v 1.1.1.1 2003/10/29 10:05:10 wschweer Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __COBJECT_H__
#define __COBJECT_H__

#include "config.h"

#include <qmainwindow.h>
#include <list>

class Xml;

//---------------------------------------------------------
//   TopWin
//---------------------------------------------------------

class TopWin : public QMainWindow
      {
      Q_OBJECT

   public:
      virtual void readStatus(Xml&);
      virtual void writeStatus(int, Xml&) const;
      TopWin(QWidget* parent=0, const char* name=0,
         WFlags f = WType_TopLevel|WDestructiveClose);
      };

//---------------------------------------------------------
//   Toplevel
//---------------------------------------------------------

class Toplevel {
   public:
      enum ToplevelType { PIANO_ROLL, NOTEN, LISTE, DRUM,
         M_MIXER, MASTER, WAVE, LMASTER, A_MIXER,
         CLIPLIST, MIXDOWN, MARKER
#ifdef PATCHBAY
         , M_PATCHBAY
#endif /* PATCHBAY */
         };
      Toplevel(ToplevelType t, int obj, TopWin* cobj) {
            _type = t;
            _object = obj;
            _cobject = cobj;
            }
      ToplevelType type() const { return _type; }
      int object()        const { return _object; }
      TopWin* cobject()   const { return _cobject; }

   private:
      ToplevelType _type;
      int _object;
      TopWin* _cobject;
      };

typedef std::list <Toplevel> ToplevelList;
typedef ToplevelList::iterator iToplevel;
typedef ToplevelList::const_iterator ciToplevel;

#endif

