/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.TimeBoundingBox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;
import logformat.slog2.BufForObjects;
import logformat.slog2.input.BufStub;
import logformat.slog2.input.IteratorOfGroupObjects;
import logformat.slog2.input.TreeNode;

public class TreeFloor
extends TreeMap {
    private short depth;
    private TimeBoundingBox timebounds;

    public TreeFloor(short s) {
        this.depth = s;
        this.timebounds = new TimeBoundingBox();
    }

    public short getDepth() {
        return this.depth;
    }

    public TimeBoundingBox firstTimeBounds() {
        return (TimeBoundingBox)super.firstKey();
    }

    public TimeBoundingBox lastTimeBounds() {
        return (TimeBoundingBox)super.lastKey();
    }

    public TimeBoundingBox getTimeBounds() {
        this.timebounds.setEarliestTime(this.firstTimeBounds().getEarliestTime());
        this.timebounds.setLatestTime(this.lastTimeBounds().getLatestTime());
        if (!this.timebounds.isTimeOrdered()) {
            System.out.println("slog2.input.TreeFloor.getTimeBounds() returns wrong " + this.timebounds);
        }
        return this.timebounds;
    }

    public boolean coversBarely(TimeBoundingBox timeBoundingBox) {
        return this.firstTimeBounds().contains(timeBoundingBox.getEarliestTime()) && this.lastTimeBounds().contains(timeBoundingBox.getLatestTime());
    }

    public boolean covers(TimeBoundingBox timeBoundingBox) {
        this.getTimeBounds();
        return this.timebounds.covers(timeBoundingBox);
    }

    public boolean overlaps(TimeBoundingBox timeBoundingBox) {
        this.getTimeBounds();
        return this.timebounds.overlaps(timeBoundingBox);
    }

    public boolean disjoints(TimeBoundingBox timeBoundingBox) {
        this.getTimeBounds();
        return this.timebounds.disjoints(timeBoundingBox);
    }

    public void pruneToBarelyCovering(TimeBoundingBox timeBoundingBox) {
        if (this.covers(timeBoundingBox)) {
            double d = timeBoundingBox.getEarliestTime();
            double d2 = timeBoundingBox.getLatestTime();
            while (!this.coversBarely(timeBoundingBox)) {
                if (!this.firstTimeBounds().contains(d)) {
                    super.remove(super.firstKey());
                }
                if (this.lastTimeBounds().contains(d2)) continue;
                super.remove(super.lastKey());
            }
        }
    }

    public Iterator iteratorOfDrawables(TimeBoundingBox timeBoundingBox, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            return new ForeItrOfDrawables(timeBoundingBox, bl, bl3);
        }
        return new BackItrOfDrawables(timeBoundingBox, bl, bl3);
    }

    public Iterator iteratorOfShadows(TimeBoundingBox timeBoundingBox, boolean bl, boolean bl2) {
        if (bl) {
            return new ForeItrOfShadows(timeBoundingBox, bl2);
        }
        return new BackItrOfShadows(timeBoundingBox, bl2);
    }

    public String toStubString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            BufStub bufStub = new BufStub((BufForObjects)iterator.next());
            stringBuffer.append(bufStub.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString() + "\n");
        }
        return stringBuffer.toString();
    }

    private class BackItrOfShadows
    extends IteratorOfGroupObjects {
        private static final boolean DECRE_STARTTIME_ORDER = false;
        private ListIterator nodes_itr;
        private boolean isNestable;

        public BackItrOfShadows(TimeBoundingBox timeBoundingBox, boolean bl) {
            super(timeBoundingBox);
            this.isNestable = bl;
            ArrayList arrayList = new ArrayList(TreeFloor.this.values());
            this.nodes_itr = arrayList.listIterator(arrayList.size());
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            while (this.nodes_itr.hasPrevious()) {
                TreeNode treeNode = (TreeNode)this.nodes_itr.previous();
                if (!treeNode.overlaps(timeBoundingBox)) continue;
                return treeNode.iteratorOfShadows(timeBoundingBox, false, this.isNestable);
            }
            return null;
        }
    }

    private class ForeItrOfShadows
    extends IteratorOfGroupObjects {
        private static final boolean INCRE_STARTTIME_ORDER = true;
        private Iterator nodes_itr;
        private boolean isNestable;

        public ForeItrOfShadows(TimeBoundingBox timeBoundingBox, boolean bl) {
            super(timeBoundingBox);
            this.isNestable = bl;
            this.nodes_itr = TreeFloor.this.values().iterator();
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            while (this.nodes_itr.hasNext()) {
                TreeNode treeNode = (TreeNode)this.nodes_itr.next();
                if (!treeNode.overlaps(timeBoundingBox)) continue;
                return treeNode.iteratorOfShadows(timeBoundingBox, true, this.isNestable);
            }
            return null;
        }
    }

    private class BackItrOfDrawables
    extends IteratorOfGroupObjects {
        private static final boolean DECRE_STARTTIME_ORDER = false;
        private ListIterator nodes_itr;
        private boolean isComposite;
        private boolean isNestable;

        public BackItrOfDrawables(TimeBoundingBox timeBoundingBox, boolean bl, boolean bl2) {
            super(timeBoundingBox);
            this.isNestable = bl2;
            this.isComposite = bl;
            ArrayList arrayList = new ArrayList(TreeFloor.this.values());
            this.nodes_itr = arrayList.listIterator(arrayList.size());
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            while (this.nodes_itr.hasPrevious()) {
                TreeNode treeNode = (TreeNode)this.nodes_itr.previous();
                if (!treeNode.overlaps(timeBoundingBox)) continue;
                return treeNode.iteratorOfDrawables(timeBoundingBox, this.isComposite, false, this.isNestable);
            }
            return null;
        }
    }

    private class ForeItrOfDrawables
    extends IteratorOfGroupObjects {
        private static final boolean INCRE_STARTTIME_ORDER = true;
        private Iterator nodes_itr;
        private boolean isComposite;
        private boolean isNestable;

        public ForeItrOfDrawables(TimeBoundingBox timeBoundingBox, boolean bl, boolean bl2) {
            super(timeBoundingBox);
            this.isNestable = bl2;
            this.isComposite = bl;
            this.nodes_itr = TreeFloor.this.values().iterator();
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            while (this.nodes_itr.hasNext()) {
                TreeNode treeNode = (TreeNode)this.nodes_itr.next();
                if (!treeNode.overlaps(timeBoundingBox)) continue;
                return treeNode.iteratorOfDrawables(timeBoundingBox, this.isComposite, true, this.isNestable);
            }
            return null;
        }
    }
}

