
/*
 * $Header: /cvsroot/mpdist/mpdist/mptool/header.c,v 1.1.1.1 2002/04/12 16:47:25 richbastard Exp $
 * 
 * Copyright (c) 1987-2002 Rich Burridge, Sun Microsystems Inc.
 * All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mptool.h"
#include "string.h"
#include "support.h"

static char *hdrs[MAXSTDHDRS];  /* The array of standard mail/news headers. */

void
Header (void)
{
    int i = 0;

    read_str(&hdrs[i++], APP_FROMHDR);
    read_str(&hdrs[i++], APP_TOHDR);
    read_str(&hdrs[i++], CCHDR);
    read_str(&hdrs[i++], CONTENT_LEN);
    read_str(&hdrs[i++], DATEHDR);
    read_str(&hdrs[i++], FROMHDR);
    read_str(&hdrs[i++], FROM_HDR);
    read_str(&hdrs[i++], NEWSGROUPHDR);
    read_str(&hdrs[i++], NEWSGROUPSHDR);
    read_str(&hdrs[i++], REPLYHDR);
    read_str(&hdrs[i++], SUBJECTHDR);
    read_str(&hdrs[i++], TOHDR);
}


void
do_hdrs_add (void)
{
    GtkWidget *hdr_list = lookup_widget(F_HDRS, "hdr_list");
    char buf[MAXLINE];
    int  n;

    STRCPY(buf, get_str_value(F_HDRS, "hdr_list_add"));
    n = strlen(buf);
    if (buf == NULL || !n) {
        notice(F_HDRS, mptool_strs[(int) S_NOTHING]);
    } else {
        if (buf[n - 1] != ':') {
            STRCAT(buf, ":");
        }
        add_list_item(hdr_list, 0, buf);
        set_str_value(F_HDRS, "hdr_list_add", "");
        gtk_list_scroll_vertical(GTK_LIST(hdr_list), GTK_SCROLL_JUMP, 0);
    }
}


void
do_hdrs_apply(void)
{
    char *liststr;
    int  found, i, j, n;
    GtkWidget *list = lookup_widget(F_HDRS, "hdr_list");
    int nrows = g_list_length(GTK_LIST(list)->children);

 
    set_int_opt_val(O_ALLHDRS, get_bool_value(F_HDRS, "hdrs_all"));
 
    for (i = 0; i < int_opt_val(O_REMHDRN); i++) {
        free_hdr(H_REMOVE, i);
    }
    set_int_opt_val(O_REMHDRN, 0);
    for (i = 0; i < MAXSTDHDRS; i++) {
        found = FALSE;
        for (j = 0; j < nrows && found == FALSE; j++) {
            GtkWidget *listitem = g_list_nth_data(GTK_LIST(list)->children, j);

            gtk_label_get(GTK_LABEL(GTK_BIN(listitem)->child), &liststr);
            if (EQUAL(liststr, hdrs[i])) {
                found = TRUE;
            }
        }
        if (found == FALSE) {
            get_hdr_arg(hdrs[i], H_REMOVE, &n);
            set_int_opt_val(O_REMHDRN, n);
        }
    }
 
    for (i = 0; i < int_opt_val(O_ADDHDRN); i++) {
        free_hdr(H_ADD, i);
    }
    set_int_opt_val(O_ADDHDRN, 0);
    for (i = 0; i < nrows; i++) {
        GtkWidget *listitem = g_list_nth_data(GTK_LIST(list)->children, i);

        found = FALSE;
        gtk_label_get(GTK_LABEL(GTK_BIN(listitem)->child), &liststr);
        for (j = 0; j < MAXSTDHDRS && found == FALSE; j++) {
            if (EQUAL(liststr, hdrs[j])) {
                found = TRUE;
            }
        }
        if (found == FALSE) {
            get_hdr_arg(liststr, H_ADD, &n);
            set_int_opt_val(O_ADDHDRN, n);
        }
    }
}


void
do_hdrs_reset(void)
{
    GtkWidget *hdr_list = lookup_widget(F_HDRS, "hdr_list");
    int i, pos;

    set_bool_value(F_HDRS, "hdrs_all", int_opt_val(O_ALLHDRS));
    gtk_list_remove_items(GTK_LIST(hdr_list), GTK_LIST(hdr_list)->children);
    for (i = 0; i < MAXSTDHDRS; i++) {
        add_list_item(hdr_list, 0, hdrs[i]);
    }

    for (i = 0; i < int_opt_val(O_ADDHDRN); i++) {
        if (item_exists(hdr_list, get_hdr(H_ADD, i)) == 0) {
            add_list_item(hdr_list, 0, get_hdr(H_ADD, i));
        }
    }

    for (i = 0; i < int_opt_val(O_REMHDRN); i++) {
        if ((pos = item_exists(hdr_list, get_hdr(H_REMOVE, i)))) {
            delete_list_item(hdr_list, pos);
        }
    }

    do_toggle_hdr_list();
}


void
do_toggle_hdr_list(void)
{
    GtkWidget *list    = lookup_widget(F_HDRS, "hdr_list");
    char      *str     = get_str_value(F_HDRS, "hdr_list_add");
    int       value    = get_bool_value(F_HDRS, "hdrs_all");
    int       selected = (GTK_LIST(list)->selection != NULL);

    set_active(F_HDRS, "hdr_list",          !value);
    set_active(F_HDRS, "hdr_list_add",      !value);
    set_active(F_HDRS, "hdr_add_label",     !value);
    set_active(F_HDRS, "hdr_add_button",    False);
    set_active(F_HDRS, "hdr_remove_button", False);

    if (!value && str && *str) {
        set_active(F_HDRS, "hdr_add_button", True);
    }
    if (!value && selected) {
        set_active(F_HDRS, "hdr_remove_button", True);
    }
}
