/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
 
  $Id: libmecab.cpp,v 1.21 2004/08/06 18:05:14 taku-ku Exp $;

  Copyright (C) 2001-2004 Taku Kudo <taku-ku@is.aist-nara.ac.jp>
  This is free software with ABSOLUTELY NO WARRANTY.
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/  
#include "mecab.h"
#include <stdexcept>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

static std::string errorStr;

struct _mecab_t {
   int allocated;
   MeCab::Tagger* ptr;
};

#ifdef _WIN32
#include <windows.h>
BOOL __stdcall DllMain( HINSTANCE, DWORD dwReason, void* )
{
   return( TRUE );
}
#endif

int mecab_do (int argc, char **argv)
{
  MeCab::Tagger tagger;
  return tagger.parse (argc, argv);
}

mecab_t* mecab_new (int argc, char **argv)
{
   mecab_t *c = new mecab_t;
   MeCab::Tagger *ptr = new MeCab::Tagger;
   if (! c || ! ptr) {
      errorStr = std::string ("mecab_new(): bad alloc");
      return 0;
   }
   c->allocated = 0;

   if (! ptr->open (argc, argv)) {
     errorStr = std::string ("mecab_new(): ");
     errorStr += ptr->what ();      
     delete ptr;
     delete c;       
     return 0;
   }

   c->ptr = ptr;
   c->allocated = 1;
   return c;
}

mecab_t* mecab_new2 (char *arg)
{
   mecab_t *c = new mecab_t;
   MeCab::Tagger *ptr = new MeCab::Tagger;
   if (! c || ! ptr) {
      errorStr = std::string ("mecab_new2(): bad alloc");
      return 0;
   }
   c->allocated = 0;
   if (! ptr->open (arg)) {
     errorStr = std::string ("mecab_new2(): ");
     errorStr += ptr->what ();      
     delete ptr;
     delete c; 
     return 0;
   }

   c->ptr = ptr;
   c->allocated = 1;
   return c;
}

char* mecab_strerror (mecab_t *c)
{
   if (! c || ! c->allocated) return const_cast<char *>(errorStr.c_str ());
   return const_cast<char *>(c->ptr->what());
}

void mecab_destroy (mecab_t *c)
{
  if (c && c->allocated) {
     delete c->ptr;
     delete c;
  }
  c = 0;
}

#define MECAB_CHECK_FIRST_ARG(a,c,t) \
 if (! (c) || ! (c)->allocated) { \
    errorStr = a; \
    errorStr += ": first argment seems to be invalid"; \
    return 0; \
 } \
 MeCab::Tagger *(t) = (c)->ptr;

int mecab_lock (mecab_t *c)
{
   MECAB_CHECK_FIRST_ARG("mecab_lock",c,t);
   return static_cast<int>(t->lock ());
}

int mecab_unlock (mecab_t *c)
{
   MECAB_CHECK_FIRST_ARG("mecab_unlock",c,t);
   return static_cast<int>(t->unlock ());
}

char* mecab_sparse_tostr (mecab_t *c, char *str)
{
  MECAB_CHECK_FIRST_ARG("mecab_sparse_tostr",c,t);
  return const_cast<char *>(t->parse (str));
}

char* mecab_sparse_tostr2 (mecab_t *c, char *str, unsigned int len)
{
  MECAB_CHECK_FIRST_ARG("mecab_sparse_tostr2",c,t);
  return const_cast<char *>(t->parse (str, len));
}

char* mecab_sparse_tostr3 (mecab_t *c, char *str, unsigned int len, 
			   char *out, unsigned int len2)
{
  MECAB_CHECK_FIRST_ARG("mecab_sparse_tostr3",c,t);
  return const_cast<char *>(t->parse (str, len, out, len2));
}

mecab_node_t* mecab_sparse_tonode (mecab_t *c, char *str)
{
  MECAB_CHECK_FIRST_ARG("mecab_sparse_tonode",c,t);
  return reinterpret_cast<mecab_node_t *>(t->parseToNode (str));
}

mecab_node_t* mecab_sparse_tonode2 (mecab_t *c, char *str, unsigned int len)
{
  MECAB_CHECK_FIRST_ARG("mecab_sparse_tonode2",c,t);
  return reinterpret_cast<mecab_node_t *>(t->parseToNode (str,len));
}

char* mecab_nbest_sparse_tostr (mecab_t* c, unsigned int N, char*str)
{
  MECAB_CHECK_FIRST_ARG("mecab_nbest_sparse_tostr",c,t);
  return const_cast<char *>(t->parseNBest (N, str));
}

char* mecab_nbest_sparse_tostr2 (mecab_t* c, unsigned int N, char*str, unsigned int len)
{
  MECAB_CHECK_FIRST_ARG("mecab_nbest_sparse_tostr2",c,t);
  return const_cast<char *>(t->parseNBest (N, str, len));
}

char* mecab_nbest_sparse_tostr3 (mecab_t* c, unsigned int N, char *str, unsigned int len,
				 char *out, unsigned int len2)
{
  MECAB_CHECK_FIRST_ARG("mecab_nbest_sparse_tostr3",c,t);
  return const_cast<char *>(t->parseNBest (N, str, len, out, len2));
}

int mecab_nbest_init (mecab_t *c, char *str)
{
  MECAB_CHECK_FIRST_ARG("mecab_nbest_init",c,t);
  return t->parseNBestInit (str);
}

int mecab_nbest_init2 (mecab_t *c, char *str, unsigned int len)
{
  MECAB_CHECK_FIRST_ARG("mecab_nbest_init2",c,t);
  return t->parseNBestInit (str, len);
}

char* mecab_nbest_next_tostr (mecab_t* c)
{
  MECAB_CHECK_FIRST_ARG("mecab_nbest_next_tostr",c, t)
  return const_cast<char *>(t->next ());
}

char* mecab_nbest_next_tostr2 (mecab_t* c, char *out, unsigned int len2)
{
  MECAB_CHECK_FIRST_ARG("mecab_nbest_next_tostr2",c,t);
  return const_cast<char *>(t->next (out, len2));
}

mecab_node_t* mecab_nbest_next_tonode (mecab_t* c)
{
  MECAB_CHECK_FIRST_ARG("mecab_nbest_next_tonode",c,t);
  return reinterpret_cast<mecab_node_t *>(t->nextNode ());
}

