
# packToolsUpdate.py
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


import os

import distribTools.packBinaryToolsLib

def main (options, args):
    distribTools.packBinaryToolsLib.packToolsUpdate (options)

def _options ():
    toolBase = os.path.normpath (os.path.join (os.environ ['TOOL'], '..'))
    outdir = os.path.join (toolBase, 'update-area', 'updates')
    refdir = os.path.join (toolBase, 'update-area', 'original')
    return [
        # (optstring, varname, typechar, default, help)
        ('ftp', None, ':', 'FileExchange:ExchangeFile@p48047', 'ftp login'),
        ('staging', None, ':', '/staging/sapdb', 'staging dir on FTP server'),
        ('o', 'outdir', ':', outdir, 'name of output directory'),
        ('ref', 'refdir', ':', refdir, 'name of directory containing original files'),
        ('v', 'verbose', '', None, 'verbose output'),
        ('n', 'nocopy', '', None, 'don\'t copy files'),
        ]

if __name__ == '__main__':
    import optlib
    optlib.optMain2 (main, _options ())

