/*************************************************************************/
/*                                                                       */
/*  MacroSystem - Powerful C++ template system.                          */
/*                                                                       */
/*  http://projects.nn.com.br/                                           */
/*                                                                       */
/*  Copyright (C) 2000 Gustavo Niemeyer <gustavo@nn.com.br>              */
/*                                                                       */
/*  This library is free software; you can redistribute it and/or        */
/*  modify it under the terms of the GNU Library General Public          */
/*  License as published by the Free Software Foundation; either         */
/*  version 2 of the License, or (at your option) any later version.     */
/*                                                                       */
/*  This library is distributed in the hope that it will be useful,      */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    */
/*  Library General Public License for more details.                     */
/*                                                                       */
/*  You should have received a copy of the GNU Library General Public    */
/*  License along with this library; if not, write to the                */
/*  Free Software Foundation, Inc., 59 Temple Place - Suite 330,         */
/*  Boston, MA  02111-1307, USA.                                         */
/*                                                                       */
/*************************************************************************/

// $Revision: 1.5 $
// $Date: 2000/02/03 05:43:56 $

#include <iostream>
#include <fstream>
#include <macrosystem.hh>

using namespace macrosystem;

int main()
{

  MacroSystem macro;

  // Set some macros

  macro["library"] = "MacroSystem";
  macro["author"] = "Gustavo Niemeyer";
  macro["homepage"] = "http://projects.nn.com.br";

  // You could output the macro below, but we are only going to
  // use it as a flag. You can use any macro as a flag.

  macro["works"] = "Yes!";

  // Set a recursive macro

  macro["recursive"] = "<%temp%>";
  macro["temp"] = "recursive";

  // Set a macro with parsing off
  
  macro["parse_off"] = "like <%this%> one";
  macro["parse_off"].parse(false);
  macro["this"] = "Oops, parsing is off!";

  // You could also use the set() method like this:
  //macro["parse_off"].set("like <%this%> one",false);
  
  // Set macros to be nested

  macro["nested_one"] = "Nested one!";
  macro["nested_two"] = "Nested two!";

  // Remove a defined and an undefined macro

  macro["defined"] = "just define it";
  macro["defined"].erase();

  macro["undefined"].erase();

  // Import template file into macro
    
  ifstream simple("simple.txt");
  simple >> macro["simple"];

  // Output template

  cout << macro["simple"].parse() << endl;

  return 0;
}
