#ifndef __INCLUDED_PHIDGETS_RFID_H__
#define __INCLUDED_PHIDGETS_RFID_H__

#include <phidgets/phidgets.h>

typedef enum phidget_rfid_toggle {
	PHIDGET_RFID_PLUS_FIVE = 0,
	PHIDGET_RFID_EXTERNAL_LED,
	PHIDGET_RFID_ONBOARD_LED,
	PHIDGET_RFID_ENABLE
} phidget_rfid_toggle;

typedef struct PhidgetRFID_t {
	Phidget *phidget;

	/* Timestamp and last tag */
	time_t   time;
	unsigned long long l_tag;

	/* Expanded Bitfield */
	bool		onboard_led;
	bool		plus_five;
	bool		external_led;
	bool		enabled;
} PhidgetRFID;

#ifdef __cplusplus
extern "C" {
#endif

PhidgetRFID* phidget_new_PhidgetRFID();
void phidget_delete_PhidgetRFID(PhidgetRFID** const qsc);
void phidget_reset_PhidgetRFID(PhidgetRFID* const qsc);
phidget_return phidget_rfid_open(PhidgetRFID* const qsc,
	 unsigned int serial, unsigned short retries);
phidget_return phidget_rfid_close(PhidgetRFID* const qsc);
bool phidget_rfid_is_opened(PhidgetRFID const* const qsc);

phidget_return phidget_rfid_set_state(PhidgetRFID* const qsc,
	 bool enable, bool onboard_led, bool external_led, bool plus_five);
phidget_return phidget_rfid_set_toggle(PhidgetRFID* const qsc,
	 phidget_rfid_toggle which, bool state);
phidget_return phidget_rfid_get_tag(PhidgetRFID* const qsc, const int timeout);
		  
#ifdef __cplusplus
}
#endif
		  
#endif /* __INCLUDED_PHIDGETS_RFID_H__ */
