.TH DLARRB l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
DLARRB - the relatively robust representation(RRR) L D L^T, DLARRB does ``limited'' bisection to locate the eigenvalues of L D L^T,
.SH SYNOPSIS
.TP 19
SUBROUTINE DLARRB(
N, D, L, LD, LLD, IFIRST, ILAST, SIGMA, RELTOL,
W, WGAP, WERR, WORK, IWORK, INFO )
.TP 19
.ti +4
INTEGER
IFIRST, ILAST, INFO, N
.TP 19
.ti +4
DOUBLE
PRECISION RELTOL, SIGMA
.TP 19
.ti +4
INTEGER
IWORK( * )
.TP 19
.ti +4
DOUBLE
PRECISION D( * ), L( * ), LD( * ), LLD( * ), W( * ),
WERR( * ), WGAP( * ), WORK( * )
.SH PURPOSE
Given the relatively robust representation(RRR) L D L^T, DLARRB does ``limited'' bisection to locate the eigenvalues of L D L^T, W( IFIRST ) thru' W( ILAST ), to more accuracy. Intervals
[left, right] are maintained by storing their mid-points and
semi-widths in the arrays W and WERR respectively.
.br

.SH ARGUMENTS
.TP 8
N       (input) INTEGER
The order of the matrix.
.TP 8
D       (input) DOUBLE PRECISION array, dimension (N)
The n diagonal elements of the diagonal matrix D.
.TP 8
L       (input) DOUBLE PRECISION array, dimension (N-1)
The n-1 subdiagonal elements of the unit bidiagonal matrix L.
.TP 8
LD      (input) DOUBLE PRECISION array, dimension (N-1)
The n-1 elements L(i)*D(i).
.TP 8
LLD     (input) DOUBLE PRECISION array, dimension (N-1)
The n-1 elements L(i)*L(i)*D(i).
.TP 8
IFIRST  (input) INTEGER
The index of the first eigenvalue in the cluster.
.TP 8
ILAST   (input) INTEGER
The index of the last eigenvalue in the cluster.
.TP 8
SIGMA   (input) DOUBLE PRECISION
The shift used to form L D L^T (see DLARRF).
.TP 8
RELTOL  (input) DOUBLE PRECISION
The relative tolerance.
.TP 8
W       (input/output) DOUBLE PRECISION array, dimension (N)
On input, W( IFIRST ) thru' W( ILAST ) are estimates of the
corresponding eigenvalues of L D L^T.
On output, these estimates are ``refined''.
.TP 8
WGAP    (input/output) DOUBLE PRECISION array, dimension (N)
The gaps between the eigenvalues of L D L^T. Very small
gaps are changed on output.
.TP 8
WERR    (input/output) DOUBLE PRECISION array, dimension (N)
On input, WERR( IFIRST ) thru' WERR( ILAST ) are the errors
in the estimates W( IFIRST ) thru' W( ILAST ).
On output, these are the ``refined'' errors.
.TP 8
WORK    (input) DOUBLE PRECISION array, dimension (???)
Workspace.
.TP 8
IWORK   (input) INTEGER array, dimension (2*N)
Workspace.
.TP 8
INFO    (output) INTEGER
Error flag.
.SH FURTHER DETAILS
Based on contributions by
.br
   Inderjit Dhillon, IBM Almaden, USA
.br
   Osni Marques, LBNL/NERSC, USA
.br

