#ifndef _KVI_URL_BANFRAME_H_INCLUDED_
#define _KVI_URL_BANFRAME_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Andrea Parrella (anandrea@iname.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qframe.h>

class QCheckBox;

class KviListBox;
class KviPushButton;

class KviUrlBanFrame : public QFrame
{
	Q_OBJECT
public:
	KviUrlBanFrame(QWidget *parent = 0, const char *name = 0, bool banEnable = false);
	~KviUrlBanFrame();
	void saveBans();
private:
	QCheckBox     *m_pEnable;
	KviListBox    *m_pBanList;
	KviPushButton *m_pAddBtn;
	KviPushButton *m_pRemoveBtn;
protected slots:
	void enableClicked();
	void addBan();
	void removeBan();
};

#undef __kvi_extern
#ifndef _KVI_URL_BANFRAME_CPP_
	#define __kvi_extern extern
#else
	#define __kvi_extern
#endif
__kvi_extern QPtrList<QString> *g_pBanList;

#endif // _KVI_URL_BANFRAME_H_INCLUDED_
