// =============================================================================
//
//      --- kvi_simple_findwidget.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qcheckbox.h>
#include <qcursor.h>
#include <qlayout.h>
#include <qtoolbutton.h>

#include "kvi_cursor.h"
#include "kvi_defines.h"
#include "kvi_label.h"
#include "kvi_lineedit.h"
#include "kvi_pushbutton.h"
#include "kvi_simple_editor.h"
#include "kvi_simple_findwidget.h"

KviSimpleFindWidget::KviSimpleFindWidget(KviSimpleEditor *parent)
	: QFrame(parent)
{
	setFrameStyle(QFrame::StyledPanel | QFrame::Raised);
	m_pEditor = parent;
	setCursor(KviCursor::arrowCursor());
	setFont(QFont(KVI_DEFAULT_FONT));

	QGridLayout *g  = new QGridLayout(this, 13, 3, 4, 0);
	QToolButton *tb = new QToolButton(DownArrow, this);
	tb->setAutoRepeat(false);
	connect(tb, SIGNAL(clicked()), m_pEditor, SLOT(toggleFindWidget()));
	g->addWidget(tb, 0, 2);

	QFrame *f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addMultiCellWidget(f, 1, 1, 0, 2);

	KviLabel *l = new KviLabel("String to find:", this);
	g->addMultiCellWidget(l, 2, 2, 0, 2);

	m_pFindStringEdit = new KviLineEdit(this);
	g->addMultiCellWidget(m_pFindStringEdit, 3, 3, 0, 2);

	setFocusProxy(m_pFindStringEdit);

	m_pRegexpCheckBox = new QCheckBox("Regular expression", this);
	g->addMultiCellWidget(m_pRegexpCheckBox, 4, 4, 0, 2);

	m_pCaseSensitiveCheckBox = new QCheckBox("Case sensitive", this);
	m_pCaseSensitiveCheckBox->setChecked(true);
	g->addMultiCellWidget(m_pCaseSensitiveCheckBox, 5, 5, 0, 2);

	KviPushButton *b;
	b = new KviPushButton("Find &Next", this);
	b->setDefault(true);
	g->addWidget(b, 6, 0);
	connect(b, SIGNAL(clicked()), this, SLOT(findNextClicked()));

	b = new KviPushButton("Find &Previous", this);
	g->addMultiCellWidget(b, 6, 6, 1, 2);
	connect(b, SIGNAL(clicked()), this, SLOT(findPrevClicked()));

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addMultiCellWidget(f, 7, 7, 0, 2);

	l = new KviLabel("Replacement text:", this);
	g->addMultiCellWidget(l, 8, 8, 0, 2);

	m_pReplaceStringEdit = new KviLineEdit(this);
	g->addMultiCellWidget(m_pReplaceStringEdit, 9, 9, 0, 2);

	m_pReplace = new KviPushButton("&Replace", this);
	connect(m_pReplace, SIGNAL(clicked()), m_pEditor, SLOT(replace()));
	g->addWidget(m_pReplace, 10, 0);
	m_pReplace->setEnabled(m_pEditor->hasSelectedText());

	b = new KviPushButton("Replace &All", this);
	connect(b, SIGNAL(clicked()), this, SLOT(replaceAllClicked()));
	g->addMultiCellWidget(b, 10, 10, 1, 2);

	m_pReplaceAndFindNext = new KviPushButton("R&eplace Next", this);
	connect(m_pReplaceAndFindNext, SIGNAL(clicked()), this, SLOT(replaceAndFindNextClicked()));
	g->addMultiCellWidget(m_pReplaceAndFindNext, 11, 11, 0, 2);
	m_pReplaceAndFindNext->setEnabled(m_pEditor->hasSelectedText());

	m_pReplaceAllInSelection = new KviPushButton("Replace All in &Selection", this);
	connect(m_pReplaceAllInSelection, SIGNAL(clicked()), this, SLOT(replaceAllInSelectionClicked()));
	g->addMultiCellWidget(m_pReplaceAllInSelection, 12, 12, 0, 2);
	m_pReplaceAllInSelection->setEnabled(m_pEditor->hasSelectedText());

	g->setResizeMode(QGridLayout::Fixed);
	connect(m_pEditor, SIGNAL(selectionChanged()), this, SLOT(selectionChanged()));
}

KviSimpleFindWidget::~KviSimpleFindWidget()
{
	// Nothing here
}

void KviSimpleFindWidget::selectionChanged()
{
	m_pReplaceAllInSelection->setEnabled(m_pEditor->hasSelectedText());
	m_pReplaceAndFindNext->setEnabled(m_pEditor->hasSelectedText());
	m_pReplace->setEnabled(m_pEditor->hasSelectedText());
}

void KviSimpleFindWidget::findNextClicked()
{
	if( m_pRegexpCheckBox->isChecked() )
		m_pEditor->findNextRegexp();
	else
		m_pEditor->findNext();
}

void KviSimpleFindWidget::findPrevClicked()
{
	if( m_pRegexpCheckBox->isChecked() )
		m_pEditor->findPrevRegexp();
	else
		m_pEditor->findPrev();
}

void KviSimpleFindWidget::replaceAllClicked()
{
	if( m_pRegexpCheckBox->isChecked() )
		m_pEditor->replaceAllRegexp();
	else
		m_pEditor->replaceAll();
}

void KviSimpleFindWidget::replaceAndFindNextClicked()
{
	if( m_pRegexpCheckBox->isChecked() )
		m_pEditor->replaceAndFindNextRegexp();
	else
		m_pEditor->replaceAndFindNext();
}

void KviSimpleFindWidget::replaceAllInSelectionClicked()
{
	if( m_pRegexpCheckBox->isChecked() )
		m_pEditor->replaceAllInSelectionRegexp();
	else
		m_pEditor->replaceAllInSelection();
}

void KviSimpleFindWidget::mousePressEvent(QMouseEvent *e)
{
	m_pressPoint = e->pos();
}

void KviSimpleFindWidget::mouseMoveEvent(QMouseEvent *)
{
	QPoint p = m_pEditor->mapFromGlobal(QCursor::pos());
	p -= m_pressPoint;
	if( p.x() < 0 )
		p.setX(0);
	else if( (p.x() + width()) > m_pEditor->width() )
		p.setX(m_pEditor->width() - width());
	if( p.y() < 0 )
		p.setY(0);
	else if( (p.y() + height()) > m_pEditor->height() )
		p.setY(m_pEditor->height() - height());
	move(p);
}

bool KviSimpleFindWidget::focusNextPrevChild(bool /* ignored */)
{
	if( m_pFindStringEdit->hasFocus() )
		m_pReplaceStringEdit->setFocus();
	else
		m_pFindStringEdit->setFocus();
	return true;
}

#include "m_kvi_simple_findwidget.moc"
