#ifndef _KVI_RAWEVENTEDITOR_H_INCLUDED_
#define _KVI_RAWEVENTEDITOR_H_INCLUDED_

// =============================================================================
//
//      --- kvi_raweventeditor.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qwidget.h>

class QSplitter;

class KviListView;
class KviListViewItem;;
class KviPushButton;
class KviScriptDataListViewItem;
class KviScriptEditor;

class KviRawEventEditor : public QWidget
{
	Q_OBJECT
public:
	KviRawEventEditor(QWidget *parent, const char *name);
	~KviRawEventEditor();

	void commit();
protected slots:
	void makeNewEvent();
	void deleteCurEvent();
	void clearAllEvents();
	void listViewSelectionChanged(KviListViewItem *);
protected:
	KviScriptDataListViewItem *m_pCurItem;

	QSplitter       *m_pSplitter;
	KviListView     *m_pListView;
	KviScriptEditor *m_pScriptEditor;
	KviPushButton   *m_pNew;
	KviPushButton   *m_pDelete;
	KviPushButton   *m_pClear;
	void fillEventListView();
	void saveCurrentItem();
	virtual void resizeEvent(QResizeEvent *);

	KviScriptDataListViewItem *findEventItem(const char *item_key);
};

#endif // _KVI_RAWEVENTEDITOR_H_INCLUDED_
