#ifndef _KVI_MAINMENU_H_INCLUDED_
#define _KVI_MAINMENU_H_INCLUDED_

// =============================================================================
//
//      --- kvi_mainmenu.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_menubar.h"

class KviFrame;

class KviMainMenu : public KviMenuBar
{
	Q_OBJECT
public:
	KviMainMenu(KviFrame *par);
	~KviMainMenu();
public:
	KviFrame     *m_pFrm;
	KviPopupMenu *m_pOnlinePopup;
	KviPopupMenu *m_pMainPopup;
	KviPopupMenu *m_pToolsPopup;

	int m_iOnlinePopupId;
	int m_iConnectItemId;
	int m_iDockWidgetId;
public:
	void setConnectItemState(bool bIsOnline);
	void enableOnLinePopup(bool bEnable);
	void wmDockWidgetStateChanged(bool bIsVisible);
	virtual void drawContents(QPainter *);
	virtual void setBackgroundPixmap(const QPixmap &pm);
	virtual void setPalette(const QPalette &pal);
	virtual void setBackgroundMode(BackgroundMode bk);
protected slots:
	void fillToolsPopup();
};

#endif // _KVI_MAINMENU_H_INCLUDED_
