// =============================================================================
//
//      --- kvi_mainmenu.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviMainMenu"

#include <qpainter.h>

#include "kvi_accel.h"
#include "kvi_app.h"
#include "kvi_frame.h"
#include "kvi_locale.h"
#include "kvi_maintoolbar.h"
#include "kvi_mdi_manager.h"
#include "kvi_mdi_toolbar.h"
#include "kvi_mainmenu.h"
#include "kvi_options.h"
#include "kvi_popupmenu.h"
#include "kvi_settings.h"
#include "kvi_statusbar.h"
#include "kvi_systray_bar.h"
#include "kvi_taskbar.h"
#include "kvi_usertoolbar.h"
#include "kvi_usertoolbartemplate.h"

extern KviUserToolBarTemplate *g_pUserToolBarTemplate;

/**
 * ============ KviMainMenu ============
 */
KviMainMenu::KviMainMenu(KviFrame *par)
	: KviMenuBar(par, "main_menu")
{
	m_pFrm = par;

	// Create the menu
	m_pMainPopup = new KviPopupMenu(this, "main_popup");
	m_pMainPopup->insertTearOffHandle();
	m_pMainPopup->setCaption(_i18n_("KVIrc"));
	m_pMainPopup->insertItem(_i18n_("&New Session"), g_pApp, SLOT(createNewFrame()), QAccel::stringToKey(_i18n_("Ctrl+N")));
	m_pMainPopup->insertSeparator();
	m_iConnectItemId = m_pMainPopup->insertItem(
		_i18n_("C&onnect"), m_pFrm, SLOT(slot_connectToServer()), QAccel::stringToKey(_i18n_("Shift+F2"))
	);
	m_pMainPopup->insertItem(_i18n_("Recent &Servers"), m_pFrm->m_pRecentServersPopup);
	m_pMainPopup->insertSeparator();
	m_iDockWidgetId = m_pMainPopup->insertItem(_i18n_("Show &Dock Icon"), g_pApp, SLOT(slot_createWMDockWidget()));
#ifndef COMPILE_NEED_KDE
	m_pMainPopup->setItemEnabled(m_iDockWidgetId, false);
#endif
	m_pMainPopup->insertSeparator();
	m_pMainPopup->insertItem(_i18n_("&Close Session"), m_pFrm, SLOT(close()),         QAccel::stringToKey(_i18n_("Ctrl+W")));
	m_pMainPopup->insertItem(_i18n_("&Quit KVIrc"),    g_pApp, SLOT(slot_safeQuit()), QAccel::stringToKey(_i18n_("Ctrl+Q")));

	KviPopupMenu *opts = new KviPopupMenu(this, "options_popup");
	opts->insertTearOffHandle();
	opts->setCaption(_i18n_("Options"));
	opts->insertItem(_i18n_("&User Configuration..."),     g_pApp, SLOT(slot_doUserOptionsDialog()));
	opts->insertItem(_i18n_("Servers && Proxy &Hosts..."), g_pApp, SLOT(slot_doServerOptionsDialog()));
	opts->insertItem(_i18n_("&General Options..."),        g_pApp, SLOT(slot_generalOptionsDialog()));
	opts->insertItem(_i18n_("&Registered Users..."),       g_pApp, SLOT(slot_doRegUsersDialog()));
	opts->insertSeparator();
	opts->insertItem(_i18n_("&Save Preferences"),          g_pApp, SLOT(slot_saveSettings()));

	m_pToolsPopup = new KviPopupMenu(this, "tools_popup");
	connect(m_pToolsPopup, SIGNAL(aboutToShow()), this, SLOT(fillToolsPopup()));

	m_pOnlinePopup = new KviPopupMenu(this, "online_popup");
	m_pOnlinePopup->insertTearOffHandle();
	m_pOnlinePopup->setCaption(_i18n_("Online"));
	m_pOnlinePopup->insertItem(_i18n_("Recent &Channels"),  m_pFrm->m_pRecentChannelsPopup);
	m_pOnlinePopup->insertItem(_i18n_("Recent &Nicknames"), m_pFrm->m_pRecentNicknamesPopup);
	m_pOnlinePopup->insertSeparator();
	m_pOnlinePopup->insertItem(_i18n_("Channel &List"), m_pFrm, SLOT(activateListWindow()));
	m_pOnlinePopup->insertItem(_i18n_("&Server Links"), m_pFrm, SLOT(slot_requestLinks()));

	KviPopupMenu *help = new KviPopupMenu(this, "help_popup");
	help->insertTearOffHandle();
	help->setCaption(_i18n_("Help"));
	help->insertItem(_i18n_("&Help Browser"),  m_pFrm, SLOT(toggleHelpBrowser()),      QAccel::stringToKey(_i18n_("Ctrl+F1")));
	help->insertItem(_i18n_("What is &This?"), m_pFrm, SLOT(slot_whatIsThisRequest()), QAccel::stringToKey(_i18n_("Shift+F1")));
	help->insertSeparator();
	help->insertItem(_i18n_("Tip of the &Day"), g_pApp, SLOT(slot_doTipOfTheDay()));
	help->insertSeparator();
	help->insertItem(_i18n_("&About KVIrc"), g_pApp, SLOT(slot_doAboutDialog()));

	insertItem(_i18n_("&KVIrc"),   m_pMainPopup);
	insertItem(_i18n_("&Options"), opts);
	insertItem(_i18n_("&Tools"),   m_pToolsPopup);
	m_iOnlinePopupId = insertItem(_i18n_("On&line"), m_pOnlinePopup);
	setItemEnabled(m_iOnlinePopupId, false);
	insertItem(_i18n_("&Window"),  m_pFrm->m_pMdi->getWindowMenu());
	insertItem(_i18n_("&Help"),    help);
#ifdef COMPILE_NEED_KDE
	if( g_pOptions->m_bEnableDockWidget )
		wmDockWidgetStateChanged(true);
#endif
	setBackgroundMode(PaletteBackground);
}

/**
 * ============ ~KviMainMenu ============
 */
void KviMainMenu::setBackgroundMode(BackgroundMode bk)
{
	if( g_pOptions->m_bUseThemeMenubarBackground ) {
		if( backgroundPixmap() && !backgroundPixmap()->isNull() )
			KviMenuBar::setBackgroundMode(bk);
	}
}

KviMainMenu::~KviMainMenu()
{
	if( m_pOnlinePopup ) {
		delete m_pOnlinePopup;
		m_pOnlinePopup = 0;
	}
}

void KviMainMenu::setConnectItemState(bool bIsOnline)
{
	QString text;
	if( bIsOnline )
		text = _i18n_("&Disconnect");
	else
		text = _i18n_("C&onnect");
	m_pMainPopup->changeItem(m_iConnectItemId, text);
}

void KviMainMenu::enableOnLinePopup(bool bEnable)
{
	m_pOnlinePopup->setEnabled(bEnable);
	setItemEnabled(m_iOnlinePopupId, bEnable);
}

void KviMainMenu::wmDockWidgetStateChanged(bool bIsVisible)
{
	m_pMainPopup->removeItem(m_iDockWidgetId);
	if( bIsVisible ) {
		m_iDockWidgetId = m_pMainPopup->insertItem(
			_i18n_("Hide Dock Icon"), g_pApp, SLOT(slot_destroyWMDockWidget()), 0, m_iDockWidgetId, 5
		);
		g_pOptions->m_bEnableDockWidget = true;
	} else {
		m_iDockWidgetId = m_pMainPopup->insertItem(
			_i18n_("Show Dock Icon"), g_pApp, SLOT(slot_createWMDockWidget()), 0, m_iDockWidgetId, 5
		);
		g_pOptions->m_bEnableDockWidget = false;
	}
}

void KviMainMenu::setBackgroundPixmap(const QPixmap &pm)
{
	KviMenuBar::setBackgroundPixmap(pm);
	setPalette(palette());
}

void KviMainMenu::setPalette(const QPalette &pal)
{
	if( !backgroundPixmap() ) {
		KviMenuBar::setPalette(pal);
		return;
	}

	if( !backgroundPixmap()->isNull() ) {
		QPalette    p = pal;
		QColorGroup g = p.active();
		g.setBrush(QColorGroup::Button, QBrush(NoBrush));
		p.setActive(g);
		g = p.disabled();
		g.setBrush(QColorGroup::Button, QBrush(NoBrush));
		p.setDisabled(g);
		KviMenuBar::setPalette(p);
		return;
	}
}

void KviMainMenu::drawContents(QPainter *p)
{
	// It is horrible, I know... but there is no other human way.
	const QPixmap *pix = backgroundPixmap();
	if( pix ) {
		if( !pix->isNull() ) {
			p->drawTiledPixmap(0, 0, width(), height(), *pix, 0, 0);
			KviMenuBar::drawContents(p);
			return;
		}
	}
	KviMenuBar::drawContents(p);
}

void KviMainMenu::fillToolsPopup()
{
	m_pToolsPopup->clear();
	m_pToolsPopup->insertTearOffHandle();
	m_pToolsPopup->setCaption(_i18n_("Tools"));
	int id = m_pToolsPopup->insertItem(
		_i18n_("&Script Center"), m_pFrm, SLOT(slot_showScriptCenter()), QAccel::stringToKey(_i18n_("Shift+F5"))
	);
	m_pToolsPopup->setItemEnabled(id, !g_pApp->scriptCenterDialogOpen());
	id = m_pToolsPopup->insertItem(_i18n_("&Directory Browser"), m_pFrm, SLOT(toggleDirBrowser()));
	m_pToolsPopup->setItemChecked(id, m_pFrm->dirBrowserOpen());

	m_pToolsPopup->insertSeparator();

	m_pToolsPopup->insertItem(
		_i18n_("Save &Current Script..."), g_pApp, SLOT(slot_doScriptWizard()), QAccel::stringToKey(_i18n_("Ctrl+S"))
	);
	m_pToolsPopup->insertItem(
		_i18n_("Load Scri&pt..."), g_pApp, SLOT(slot_doLoadScriptDialog()), QAccel::stringToKey(_i18n_("Ctrl+L"))
	);

	m_pToolsPopup->insertSeparator();

	id = m_pToolsPopup->insertItem(_i18n_("Status&bar"), m_pFrm, SLOT(slot_toggleStatusBar()));
	m_pToolsPopup->setItemChecked(id, m_pFrm->m_pStatusBar->isVisible());
	id = m_pToolsPopup->insertItem(_i18n_("T&askbar"), m_pFrm, SLOT(slot_toggleTaskBar()));
	m_pToolsPopup->setItemChecked(id, m_pFrm->m_pTaskBar->isVisible());
	id = m_pToolsPopup->insertItem(_i18n_("T&oolbar"), m_pFrm, SLOT(slot_toggleToolBar()));
	m_pToolsPopup->setItemChecked(id, m_pFrm->m_pToolBar->isVisible());
	id = m_pToolsPopup->insertItem(_i18n_("&MDI Toolbar"), m_pFrm, SLOT(slot_toggleMdiToolBar()));
	m_pToolsPopup->setItemChecked(id, m_pFrm->m_pMdiToolBar->isVisible());
	id = m_pToolsPopup->insertItem(_i18n_("S&ystem Tray Bar"), m_pFrm, SLOT(slot_toggleSysTrayBar()));
	m_pToolsPopup->setItemChecked(id, m_pFrm->m_pSysTrayBar->isVisible());
	id = m_pToolsPopup->insertItem(_i18n_("&User Toolbar"), m_pFrm, SLOT(slot_toggleUserToolBar()));
	m_pToolsPopup->setItemEnabled(id, !g_pUserToolBarTemplate->isEmpty());
	m_pToolsPopup->setItemChecked(id, m_pFrm->m_pUserToolBar->isVisible());

	m_pToolsPopup->insertSeparator();

	m_pToolsPopup->insertItem(_i18n_("Arrange Toolbars (Normal)"),  m_pFrm, SLOT(slot_lineUpToolBarsNormal()));
	m_pToolsPopup->insertItem(_i18n_("Arrange Toolbars (Compact)"), m_pFrm, SLOT(slot_lineUpToolBarsCompact()));
}

#include "m_kvi_mainmenu.moc"
