#ifndef _KVI_DCC_CHAT_H_INCLUDED_
#define _KVI_DCC_CHAT_H_INCLUDED_

// =============================================================================
//
//      --- kvi_dcc_chat.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_dcc_chat_thread.h"
#include "kvi_string.h"
#include "kvi_window.h"

class KviIrcView;

class KviDccChat : public KviWindow
{
	Q_OBJECT
public:
	KviDccChat(KviFrame *, const char *name);
	~KviDccChat();

	void acceptDccRequest(const char *nick, const char *username, const char *host, unsigned long addr, unsigned short port);
	void requestDcc(const char *nick, const char *username, const char *host);
	bool sendData(const char *buffer);

	KviStr            m_szLocalNick;
	KviStr            m_szLocalMask;
	KviStr            m_szRemoteNick;
protected:
	virtual QPixmap *myIconPtr();
	virtual void     resizeEvent(QResizeEvent *);
	virtual void     applyOptions();
	virtual bool     event(QEvent *);
	virtual void     closeEvent(QCloseEvent *);

	void abortThread();

	KviDccChatThread *m_thread;
	KviDccChatData   *m_pDccChatData;
	KviStr            m_szRemoteMask;
	KviStr            m_szRemoteInfo;
public slots:
	void viewRightClicked(KviIrcView *);
	void viewPopupClicked(const KviStr &dataBuffer);
};

#endif // _KVI_DCC_CHAT_H_INCLUDED_
