// =============================================================================
//
//      --- kvi_stringselector.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviStringSelector"

#include <qobjectlist.h>

#include "kvi_debug.h"
#include "kvi_label.h"
#include "kvi_lineedit.h"
#include "kvi_string.h"
#include "kvi_stringselector.h"

KviStringSelector::KviStringSelector(
	QWidget *parent, const char *description, KviStr *pString, bool bEnabled, int fieldWidth, const char *name)
	: QWidget(parent, name)
{
	__range_valid(pString);
	m_pString = pString;

	m_pLabel = new KviLabel(_CHAR_2_QSTRING(description), this);
	m_pEdit  = new KviLineEdit(this);
	m_pEdit->setText(pString->ptr());
	m_iFieldWidth = (fieldWidth > 0) ? fieldWidth : 300;
	setMinimumWidth(m_iFieldWidth + m_pLabel->sizeHint().width() + 1);
	setMinimumHeight(m_pEdit->sizeHint().height());
	setEnabled(bEnabled);
}

KviStringSelector::~KviStringSelector()
{
	// Nothing here
}

void KviStringSelector::commitChanges()
{
	*m_pString = m_pEdit->text();
}

void KviStringSelector::commitAll(QWidget *w)
{
	QObjectList *l = w->queryList("KviStringSelector");
	if( !l ) return;
	QObjectListIt it(*l);
	while( it.current() ) {
		((KviStringSelector *) it.current())->commitChanges();
		++it;
	}
	delete l;
}

void KviStringSelector::resizeEvent(QResizeEvent *)
{
	m_pEdit->setGeometry(width() - m_iFieldWidth, 0, m_iFieldWidth, height());
	m_pLabel->setGeometry(0, 0, width() - (m_iFieldWidth + 1), height());
}

QSize KviStringSelector::sizeHint()
{
	return QSize(m_pLabel->sizeHint().width() + m_iFieldWidth + 1, m_pEdit->sizeHint().height());
}

void KviStringSelector::setEnabled(bool bEnabled)
{
	m_pLabel->setEnabled(bEnabled);
	m_pEdit->setEnabled(bEnabled);
	QWidget::setEnabled(bEnabled);
}

#include "m_kvi_stringselector.moc"
