/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2004	  by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef PROJECTPREF_H
#define PROJECTPREF_H

#include <kdialogbase.h>
#include <qptrlist.h>

class SavePreferences;
class IdentityPreferences;
class MiscPreferences;
class SpellPreferences;
class CatmanPreferences;
class DirCommandsPreferences;
class FileCommandsPreferences;
class ViewPreferences;

#include "kbproject.h"
#include "projectsettings.h"
#include "context.h"

namespace KBabel {

class ProjectDialog : public KDialogBase
{
    Q_OBJECT
public:
    ProjectDialog(Project::Ptr project);

public slots:
    void updateSaveSettings(KBabel::SaveSettings);
    void updateIdentitySettings(KBabel::IdentitySettings);
    void updateMiscSettings(KBabel::MiscSettings);
    void updateSourceContextSettings(SourceContextSettings);
    void updateCatManSettings(KBabel::CatManSettings);

protected slots:
   virtual void slotHelp();
   virtual void slotDefault();
   virtual void slotApply();
   virtual void slotOk();
   virtual void slotCancel();


private:
    SavePreferences *_savePage;
    IdentityPreferences* _identityPage;
    MiscPreferences* _miscPage;
    SpellPreferences* _spellPage;
    SourceContextPreferences* _sourcePage;
    CatmanPreferences *_catmanPage;
    DirCommandsPreferences *_dirCommandsPage;
    FileCommandsPreferences *_fileCommandsPage;
    ViewPreferences *_viewPage;

    KBabel::SaveSettings _saveSettings;
    KBabel::IdentitySettings _idSettings;
    KBabel::SpellcheckSettings _spellcheckSettings;
    KBabel::MiscSettings _miscSettings;
    SourceContextSettings _sourceSettings;
    KBabel::CatManSettings _CatManSettings;
    
    Project::Ptr _project;
};

}

#endif // PROJECTPREF_H
