%{

#define YY_NO_UNPUT

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "tokens.h"


%}

%option prefix="GettextBase"

%option noyywrap

%%

[ ]*[\n]	;
msgid		{
		    return T_MSGID;
		}
msgid_plural	{
		    return T_MSGIDPLURAL;
		}
msgstr\[[0-9]+\]	{
		    return T_MSGSTR;
		}
msgstr		{
		    return T_MSGSTR;
		}
#~[^\n]*	{
		   return T_OBSOLETE;
		}

#[^\n]*		{
		   return T_COMMENT;
		}
\"([^\n]*(\\\")?)*\"\n	{
			yytext[strlen(yytext)-2] = 0;
			yytext++;
		   return T_STRING;
		}

.		;

<<EOF>>		{
		    return T_EOF;
		}

%%
