<?php
/*
 * $Horde: imp/test.php,v 1.2.2.10 2004/03/26 22:43:24 jan Exp $
 *
 * Copyright 2002-2004 Brent J. Nordquist <bjn@horde.org>
 * Copyright 1999-2004 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2004 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/* We want to be as verbose as possible here. */
error_reporting(E_ALL);

/* Set character encoding. */
header('Content-type: text/html; charset=utf-8');
header('Vary: Accept-Language');

function status($foo) {
    if ($foo) {
        echo '<font color="green"><b>Yes</b></font>';
    } else {
        echo '<font color="red"><b>No</b></font>';
    }
}

/* IMP version. */
require_once './lib/version.php';
$version = IMP_VERSION;

/* Parse PHP version. */
function split_php_version($version)
{
    // First pick off major version, and lower-case the rest.
    if (strlen($version) >= 3 && $version[1] == '.') {
        $phpver['major'] = substr($version, 0, 3);
        $version = substr(strtolower($version), 3);
    } else {
        $phpver['major'] = $version;
        $phpver['class'] = 'unknown';
        return $phpver;
    }
    if ($version[0] == '.') {
        $version = substr($version, 1);
    }
    // Next, determine if this is 4.0b or 4.0rc; if so, there is no minor,
    // the rest is the subminor, and class is set to beta.
    $s = strspn($version, '0123456789');
    if ($s == 0) {
        $phpver['subminor'] = $version;
        $phpver['class'] = 'beta';
        return $phpver;
    }
    // Otherwise, this is non-beta;  the numeric part is the minor,
    // the rest is either a classification (dev, cvs) or a subminor
    // version (rc<x>, pl<x>).
    $phpver['minor'] = substr($version, 0, $s);
    if ((strlen($version) > $s) && ($version[$s] == '.' || $version[$s] == '-')) {
        $s++;
    }
    $phpver['subminor'] = substr($version, $s);
    if ($phpver['subminor'] == 'cvs' || $phpver['subminor'] == 'dev' || substr($phpver['subminor'], 0, 2) == 'rc') {
        unset($phpver['subminor']);
        $phpver['class'] = 'dev';
    } else {
        if (!$phpver['subminor']) {
            unset($phpver['subminor']);
        }
        $phpver['class'] = 'release';
    }
    return $phpver;
}

/* Display PHP version bullets. */
function show_php_version($phpver)
{
    echo '    <li>PHP Major Version: ' . $phpver['major'] . "</li>\n";
    if (isset($phpver['minor'])) {
        echo '    <li>PHP Minor Version: ' . $phpver['minor'] . "</li>\n";
    }
    if (isset($phpver['subminor'])) {
        echo '    <li>PHP Subminor Version: ' . $phpver['subminor'] . "</li>\n";
    }
    echo '    <li>PHP Version Classification: ' . $phpver['class'] . "</li>\n";
}

/* PHP Version. */
$phpver = split_php_version(phpversion());

/* Handle special modes. */
if (array_key_exists('mode', $_GET) && $_GET['mode'] == 'phpinfo') {
    echo '<a href="?mode=test">&lt;&lt; Back to test.php</a>';
    phpinfo();
    exit;
    break;
}

/* See if we have the imap module installed */
$imap = extension_loaded('imap');

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1-transitional.dtd">

<html>
<head>
<title>IMP: System Capabilities Test</title>
<style type="text/css">
<!--
body { font-family: Geneva,Arial,Helvetica,sans-serif; font-size: 10pt; }
td { font-family: Geneva,Arial,Helvetica,sans-serif; font-size: 10pt; }
h1 { font-size: 12pt; color: black; font-family: Verdana,Geneva,Arial,Helvetica,sans-serif; }
-->
</style>
</head>

<body bgcolor="#ffffff" text="#000000">

<table border="0" cellpadding="2" cellspacing="0" width="100%">
<tr><td>

<h1>IMP Version</h1>
<ul>
    <li>IMP: <?php echo $version; ?></li>
</ul>

<h1>PHP Version</h1>
<ul>
    <li><a href="test.php?mode=phpinfo">View phpinfo() screen</a></li>
    <li>PHP Version: <?php echo phpversion(); ?></li>
<?php
    show_php_version($phpver);
    if ($phpver['major'] < '4.0') {
        echo '        <li><font color="red">You need to upgrade to PHP4. PHP3 will not work.</font></li>';
        $requires = 1;
    } elseif ($phpver['class'] == 'beta' || $phpver['class'] == 'unknown') {
        echo '        <li><font color="red">This is a beta/prerelease version of PHP4. You need to upgrade to a release version.</font></li>';
        $requires = 1;
    } elseif ($phpver['major'] == '4.0') {
        echo '        <li><font color="red">This version of PHP is not supported. You need to upgrade to a more recent version.</font></li>';
        $requires = 1;
    } elseif ($phpver['major'] == '4.1' || $phpver['major'] == '4.2' || $phpver['major'] == '4.3' || $phpver['major'] == '4.4') {
        if ($phpver['major'] == '4.1' && $phpver['minor'] < '2') {
            $insecure = 1;
        }
        echo '        <li><font color="green">You are running a supported version of PHP.</font></li>';
    } else {
        echo '        <li><font color="orange">Wow, a mystical version of PHP from the future. Let <a href="mailto:dev@lists.horde.org">dev@lists.horde.org</a> know what version you have so we can fix this script.</font></li>';
    }
    if (!empty($requires)) {
        echo '        <li>IMP requires PHP 4.1.0 or later.</li>';
    }
    if (!empty($insecure)) {
        echo '        <li><font color="orange">This version of PHP contains a serious security vulnerability in its upload code.</font> You should apply the patch or upgrade to 4.1.2 or later as soon as possible.</li>';
    }
    echo '</ul>';
?>

<h1>PHP Module Capabilities</h1>
<ul>
    <li>IMAP Support: <?php status($imap) ?></li>
    <?php if (!$imap) { ?>
    <li><font color="red"><b>IMP will not function without the IMAP extension.  IMAP support is required even if you only use POP3.</b></font></li>
    <?php }  ?>
</ul>

<h1>PHP IMAP Support Test</h1>
<?php

$server = isset($_POST['server']) ? $_POST['server'] : ''; // 'server.example.com';
$protocol = isset($_POST['protocol']) ? $_POST['protocol'] : ''; // 'imap';
$port = isset($_POST['port']) ? $_POST['port'] : ''; // '143';
$user   = isset($_POST['user']) ? $_POST['user'] : '';     // 'user';
$passwd = isset($_POST['passwd']) ? $_POST['passwd'] : ''; // 'password';

if (!empty($server) && !empty($user) && !empty($passwd)) {
    if (empty($protocol)) {
        $protocol = 'imap';
    }
    if (empty($port)) {
        $port = '143';
    }
    $mbname = '{' . $server . ':' . $port . '/' . $protocol . '}INBOX';
    echo 'server="', $server, '" user="', $user, '" mailbox="', $mbname, '"<br />';
    $mbox = @imap_open($mbname, $user, $passwd);
    if ($mbox) {
        $minfo = @imap_mailboxmsginfo($mbox);
        if ($minfo) {
            echo 'INBOX has ', $minfo->Nmsgs, ' messages (' . $minfo->Unread, ' new ', $minfo->Recent, ' recent)';
        } else {
            echo '<pre>'; var_dump(imap_errors()); echo '</pre>';
        }
        @imap_close($mbox);
    } else {
        echo '<pre>'; var_dump(imap_errors()); echo '</pre>';
    }
} else {
    ?>
<form name="form1" method="post" action="test.php">
<table>
<tr><td align="right">Server</td><td><input type="text" name="server" /></td></tr>
<tr><td align="right">Protocol</td><td><input type="text" name="protocol" /></td><td>(e.g. "imap" or "imap/notls")</td></tr>
<tr><td align="right">Port</td><td><input type="text" name="port" /></td><td>(defaults to "143")</td></tr>
<tr><td align="right">User</td><td><input type="text" name="user" /></td></tr>
<tr><td align="right">Password</td><td><input type="password" name="passwd" /></td></tr>
<tr><td></td><td><input type="submit" name="f_submit" value="Submit" /><input type="reset" name="f_reset" value="Reset" /></td></tr>
</table>
</form>
<?php } ?>

</td></tr>
</table>

<p align="left">
<a href="http://validator.w3.org/check/referer"><img src="http://validator.w3.org/images/vxhtml10" alt="Valid XHTML 1.0!" height="31" width="88" border="0" hspace="5" /></a>
</p>

</body>
</html>
