#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
# $Id: scrollbar.py 6851 2005-01-03 20:59:28Z jcater $

from wxPython.wx import *

from gnue.common import events
from gnue.forms.uidrivers.wx.widgets._base import UIHelper
from gnue.forms.uidrivers.wx.common import _eventObjTowxWindow
from gnue.forms.uidrivers.wx.common import _setDefaultEventHandlers


# =============================================================================
# Wrap an UI layer around a scrollbar used to navigating multiple records
# =============================================================================
class UIScrollBar(UIHelper):
  """
  Creates a single instance of a scrollbar.
  """

  # --------------------------------------------------------------------------
  # Create a scrollbar widget
  # --------------------------------------------------------------------------
  def _createWidget(self, event, spacer):
    """
    Creates a new wxScrollBar widget.
    """
    object = event.object

    itemX =      self.itemX
    itemY =      (object.Char__y + spacer) * event.widgetHeight
    itemWidth =  object.Char__width * event.widgetWidth
    itemHeight = object.Char__height * event.widgetHeight

    newWidget = self._widget = wxScrollBar(event.container, -1,
                           wxPoint(itemX, itemY),
                           wxSize(itemWidth, itemHeight),
                           wxSB_VERTICAL)

    if event.initialize:
      self._eventHandler = event.eventHandler
      EVT_COMMAND_SCROLL(newWidget, newWidget.GetId(), self.scrollbarHandler)
      _setDefaultEventHandlers(newWidget, event.eventHandler, event.initialize,self._uiDriver)

      object._block.registerScrollbar(self)
      self._rows = object._block._rows

    return newWidget


  # --------------------------------------------------------------------------
  # Handle scrollbar events
  # --------------------------------------------------------------------------
  def scrollbarHandler(self, event):
    """
    Handles scrollbar events.
    """
    object = _eventObjTowxWindow(event)
    id = object.GetId()

    value = object.GetThumbPosition()
    recno = int(value) + 1

    gfObject = self._uiDriver._IdToGFObj[id]
    action = events.Event('requestRECORDNUMBER', object=gfObject, data=recno,
                          _form=gfObject._form)
    self._eventHandler(action)


  # --------------------------------------------------------------------------
  # Adjusts scrollbar pos and size
  # --------------------------------------------------------------------------
  def adjustScrollbar(self, pos, range):
    """
    Adjusts the scrollbar's position and size
    """
    # position, thumbSize, range, pageSize, refresh = TRUE
    self._widget.SetScrollbar(pos, self._rows, range + self._rows - 1, self._rows - 1)


# ----------------------------------------------------------------------------
# Configuration data
# ----------------------------------------------------------------------------
configuration = {
    'baseClass'  : UIScrollBar,
    'provides'   : 'GFScrollBar',
    'container'  : 0,
    }
