# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# $Id: image.py 6851 2005-01-03 20:59:28Z jcater $
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#

from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Image
from gnue.forms.uidrivers.win32.common import getNextId
import win32con

#
# UIImage
#
# Widget set specific function that creates a single instance of an image
#
class UIImage(UIHelper):

  def _createWidget(self, event, spacer):
    object = event.object
    style = win32con.WS_CHILD | win32con.WS_VISIBLE | win32con.SS_BITMAP
    styleEx = 0
    newWidget = Win32Image(self._uiDriver, styleEx, 'STATIC', '', style,
                        self.itemX,
                        self.itemY, 
                        self.itemWidth,
                        self.itemHeight,
                        event.container, getNextId())
    return newWidget


configuration = {
    'baseClass'  : UIImage,
    'provides'   : 'GFImage',
    'container'  : 0,
    }
